﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//    Copyright © ABC SOFTWARE. All rights reserved.
//    The source code or its parts to use, reproduce, transfer, copy or
//    keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.DeleteMessageList
{
    using System;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using ProxyToService;
    using ProxyToService.DitService;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            string channelName = "SampleChannel";
            string channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
            //string channelVersionURN = "URN:IVIS:100001:CHA-" + channelName + "-v1-0-TYPE-DIK";

            using (ProxyToService.DitService.DITMessageServiceContractClient client = new ProxyToService.DitService.DITMessageServiceContractClient("MessageServiceUser"))
            {
                try
                {
                    client.ClientCredentials.UserName.UserName = System.Configuration.ConfigurationManager.AppSettings.Get("VraaUserName");
                    client.ClientCredentials.UserName.Password = System.Configuration.ConfigurationManager.AppSettings.Get("VraaPassword");

                    MessageRequestStructure messageRequest = new MessageRequestStructure();
                    messageRequest.Item = channelURN;

                    MessageResponseStructure2 resp = client.ReceiveMessage2(messageRequest);

                    if (resp != null && resp.Items != null)
                    {
                        foreach (var item in resp.Items)
                        {
                            Console.WriteLine("message receved id:" + item.MessageID);
                            MessageRequestStructure messageRequestDelete = new MessageRequestStructure();
                            messageRequestDelete.Item = item.MessageID;
                            messageRequestDelete.ItemElementName = ItemChoiceType.MessageID;
                            client.DeleteMessage(messageRequestDelete);
                            Console.WriteLine("message deleted id:" + item.MessageID);
                        }
                    }

                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }
    }
}