﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//    Copyright © ABC SOFTWARE. All rights reserved.
//    The source code or its parts to use, reproduce, transfer, copy or
//    keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.LoginUserName
{
    using System;
    using System.ServiceModel;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            using (ProxyToService.DitConfiguration.DITConfigurationServiceContractClient client = new ProxyToService.DitConfiguration.DITConfigurationServiceContractClient("ConfigurationServiceuser"))
            {
                try
                {
                    client.ClientCredentials.UserName.UserName = System.Configuration.ConfigurationManager.AppSettings.Get("UserName");
                    client.ClientCredentials.UserName.Password = System.Configuration.ConfigurationManager.AppSettings.Get("Password");

                    ProxyToService.DitConfiguration.PostBoxInfoStructure postBox = client.SelectPostBox("100001");

                    if (postBox != null)
                    {
                        Console.WriteLine(postBox.PostBoxID);
                    }

                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }
    }
}