<?php
//header("Content-Type: text/html; charset=UTF-8");
/** 
 * client.php 
 * 
 * Copyright (c) 2010, ABC Software SIA <abcsoftware@abcsoftware.lv>. 
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 *   * Redistributions of source code must retain the above copyright 
 *     notice, this list of conditions and the following disclaimer. 
 * 
 *   * Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the 
 *     distribution. 
 * 
 *   * Neither the name of Sergejs Degtjars nor the names of his 
 *     contributors may be used to endorse or promote products derived 
 *     from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE. 
 * 
 * @author     Sergejs Degtjars <sergejs.degtjars@abcsoftware.lv> 
 * @copyright  2010 ABC Software SIA <abcsoftware@abcsoftware.lv> 
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License 
 * @version    0.1.0  alpha
 */
require_once('lib/sts_client.php');
require_once('hg/soap-wsa.php');
require_once('hg/soap-wsse.php');
require_once('lib/ivisrequest.php');
require_once('lib/SAMLProcessing.php'); 

$milestones = array();

class mySOAP extends SoapClient {
    public $customtoken;
    
    function __doRequest($request, $location, $saction, $version, $one_way = NULL) {
        $dom = new DOMDocument();
        $dom->loadXML($request);

        $objWSA = new WSASoap($dom);
        $objWSA->addAction($saction);
        $objWSA->addMessageID();
        $objWSA->addReplyTo();
        $objWSA->addTo($location);
        $dom = $objWSA->getDoc();
        
        $objWSSE = new WSSESoap($dom);
        $objWSSE->addTimestamp();
        // signing TimeStamp
        /* create new XMLSec Key using HMAC-SHA1 and type is public key */
        $objKey = new XMLSecurityKey(XMLSecurityKey::HMAC_SHA1, array('type'=>'public'));
        
        /* load the private key from file - last arg is bool if key in file (TRUE) or is string (FALSE) */
        $objKey->Key = $this->customtoken['key'];
        
        /* Sign the message - also signs appropraite WS-Security items */
        $objWSSE->signTimestampOnly = TRUE;
        $options = array("insertBefore" => FALSE);
        $objWSSE->signSoapDoc($objKey, $options);
        $objWSSE->attachReftoSig($this->customtoken['arkeyid']);
        // Adding Endorsed token
        $placeholder = '<tokenplaceholder/>';
		$objWSSE->addCustomTokenPlaceholder($placeholder);
        
		$request = $objWSSE->saveXML();
		$GLOBALS['milestones']['service_request'] = $request;
		//Hack		
        $request = str_replace($placeholder,  $this->customtoken['token'], $request);
		

        $response = parent::__doRequest($request, $location, $saction, $version);
		$GLOBALS['milestones']['service_response'] = $response;
		return $response;
    }
}


$sts_address_s12 = 'https://epaktest.abcsoftware.lv:444/PFAS/IVIS.Pfas.STS/STS/Issue.svc/trust/2005/certificatemixed';
$apply_to =  'https://epaktest.abcsoftware.lv:444/Request.WebService/V1-7/RequestWcfService.svc/samlOverTransportPolicy';

$service_addr = 'https://epaktest.abcsoftware.lv:444/Request.WebService/V1-7/RequestWcfService.svc/soap11IssuedToken';
$service_wsdl = 'https://epaktest.abcsoftware.lv:444/Request.WebService/V1-7/RequestWcfService.svc?wsdl';

$sts = new STSClient(NULL, array('location' => $sts_address_s12,
                            'uri' => 'http://schemas.xmlsoap.org/ws/2005/02/trust',
                            'exceptions' => TRUE,
                            'style'    => SOAP_DOCUMENT,
                            'use'      => SOAP_LITERAL,
                            'soap_version' => SOAP_1_2,
                            'trace' => TRUE));



$service = new mySOAP($service_wsdl, array('exceptions' => TRUE,
                                         'soap_version' => SOAP_1_1,
                                         'location' => $service_addr,
                                         'trace' => TRUE));
/*$service2 = new mySOAP($service_wsdl, array('exceptions' => TRUE,
                                         'soap_version' => SOAP_1_1,
                                         'location' => $service_addr,
                                         'trace' => TRUE));*/

try {                                         
try {
    // set UsernameToken variables and request for tokens
    $cert = file_get_contents('cert/public.pem');
	$private_key = file_get_contents('cert/not_enc.pem');
    $tokens = $sts->issueTokenCert($cert, $private_key, $apply_to);
	
    // Sergejs Degtjars: Decrypt token
    $keyfile = 'cert/localhost_enc.pem';
    $keypassword = 'qw12';
    $saml_precessing = new MySAMLProcess();
    //$decrypted_token_element = $saml_precessing->decryptToken($tokens[0]['token'], $keyfile,TRUE, $keypassword);
    
    // Sergejs Degtjars: Print decrypted token
    /*$decrypted_token = new DOMDocument('1.0', 'UTF-8');
    $decrypted_token_root = $decrypted_token->createElement('Root');
    $decrypted_token ->appendChild($decrypted_token_root);
    $decrypted_token_root->appendChild($decrypted_token->importNode($decrypted_token_element,true));
    echo($decrypted_token->saveXML());*/
    // End of Decrypt Token
    
        
    // set Token for service call - we use only first token from collection if many returned
    $service->customtoken = $tokens[0];
	
    // Iitialize IVISRequest  (1st variant with query as DOMNode instance)
    $query = new DOMDocument('1.0', 'UTF-8');
    $query -> load('nos_list.xml');
    
    $ivisRequest = new IVISRequest($query->documentElement);
    $ivisRequest->messageType = 'URN:IVIS:100001:XSD-PFASNOS-NOSList-v1-0-TYPE-NOSList';
    $ivisRequest->destination = 'URN:IVIS:100001:ISS-EPS-SendNOSList-v1-0';
    $ivisRequestStructure = $ivisRequest->genIVISRequest();
    unset($ivisRequest);
    
    // call IVISRequest-webservice
    $out = $service->SubmitSync(array('IVISRequest' => $ivisRequestStructure));
    //echo 'DOMNode request <br /> ';
    //var_dump($out);
    
	foreach ($milestones as $key => $value) {
	    $dom = new DOMDocument;
		$dom->preserveWhiteSpace = false;
		$dom->loadXML($milestones[$key]); 
		$dom->formatOutput = true;
		$milestones[$key] = $dom->saveXml();
	}

	echo json_encode($milestones);
	
	//
    //echo '<br />';
    /////////////
   /* $service2->customtoken = $tokens[0];
    // Iitialize IVISRequest  (2nd variant with query as XML string !!!! NO XML DECLARATION !!!!)
    $ivisRequest = new IVISRequest($query->saveXML($query->documentElement));
    $ivisRequest->messageType = 'URN:IVIS:100001:XSD-PFASNOS-NOSList-v1-0-TYPE-NOSList';
    $ivisRequest->destination = 'URN:IVIS:100001:ISS-EPS-SendNOSList-v1-0';
    $ivisRequestStructure = $ivisRequest->genIVISRequest();
    unset($ivisRequest);
    
    // call IVISRequest-webservice
    $out = $service2->SubmitSync(array('IVISRequest' => $ivisRequestStructure));
    echo 'XML string request <br /> ';
    var_dump($out);    */
    
} catch (SoapFault $fault) {
    var_dump($fault);
}
} catch (Exception $ex)  {
    echo $ex->getMessage();
}
?>
