<?php
/** 
 * sts_client.php 
 * 
 * Copyright (c) 2010, ABC Software SIA <abcsoftware@abcsoftware.lv>. 
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 *   * Redistributions of source code must retain the above copyright 
 *     notice, this list of conditions and the following disclaimer. 
 * 
 *   * Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the 
 *     distribution. 
 * 
 *   * Neither the name of Sergejs Degtjars nor the names of his 
 *     contributors may be used to endorse or promote products derived 
 *     from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE. 
 * 
 * @author     Sergejs Degtjars <sergejs.degtjars@abcsoftware.lv> 
 * @copyright  2010 ABC Software SIA <abcsoftware@abcsoftware.lv> 
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License 
 * @version    0.2.0  alpha
 */
 
require_once('wsse/soap-wsa.php');
require_once('wsse/soap-wsse.php');
require_once('lib/soap-wst.php');

class STSClient extends SoapClient {

   private $request;
   private $response;

   public function issueToken($username, $password, $appliesTo, array $claims = NULL) {
       $saction = 'http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue';
       switch ($this->_soap_version) {
           case SOAP_1_1:
                $soapns = 'http://schemas.xmlsoap.org/soap/envelope/';
                break;
           case SOAP_1_2:
                $soapns = 'http://www.w3.org/2003/05/soap-envelope';
                break;
       }
       $rst = new WSTSoap('http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue','13');
       $rst->setTokenType('http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1');
       $rst->setDestination($appliesTo);
       if (isset($claims)) {
           $rst->requestClaims($claims);
       }
       $rst->genEntropy();
       $rst->setTTL();
       $tokenReqPayload = $rst->saveXML($this->_soap_version);

        $request = new DOMDocument('1.0', 'UTF-8');
        $envelope = $request->createElementNS($soapns,'soap:Envelope');
        $request->appendChild($envelope);
        $body = $request->createElementNS($soapns,'soap:Body');
        $envelope->appendChild($body);
        //HACK: Begin
        $payload = $request -> createDocumentFragment();
        $payload->appendXML($tokenReqPayload);
        $body -> appendChild($payload);
        //HACK: End
        // Adding WS-Addressing headers
        $objWSA = new WSASoap($request, WSASoap::WSA_1_0);
        $objWSA->addAction($saction);
        $objWSA->addTo($this->location);
        $objWSA->addMessageID();
        $objWSA->addReplyTo();
        $request = $objWSA->getDoc();
        // Adding WS-Security headers
        $objWSSE = new WSSESoap($request);
        $objWSSE -> addTimestamp(300);
        $objWSSE ->addUserToken($username, $password);
        		
        $request = $objWSSE->saveXML();
		$this->request = $request;
        $response = $this->__doRequest($request,$this->location,$saction,$this->_soap_version);
		$this->response = $response;
        if ($response == NULL) throw new Exception('No response from STS');
        return $rst->processResponse($response);
   }
   
    public function issueTokenCert($cert, $private_key, $appliesTo, array $claims = NULL) {
       $saction = 'http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue';
       switch ($this->_soap_version) {
           case SOAP_1_1:
                $soapns = 'http://schemas.xmlsoap.org/soap/envelope/';
                break;
           case SOAP_1_2:
                $soapns = 'http://www.w3.org/2003/05/soap-envelope';
                break;
       }
       $rst = new WSTSoap('http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue','13');
       $rst->setTokenType('http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1');
       $rst->setDestination($appliesTo);
       if (isset($claims)) {
           $rst->requestClaims($claims);
       }
       $rst->genEntropy();
       $rst->setTTL();
       $tokenReqPayload = $rst->saveXML($this->_soap_version);

        $request = new DOMDocument('1.0', 'UTF-8');
        $envelope = $request->createElementNS($soapns,'soap:Envelope');
        $request->appendChild($envelope);
        $body = $request->createElementNS($soapns,'soap:Body');
        $envelope->appendChild($body);
        //HACK: Begin
        $payload = $request -> createDocumentFragment();
        $payload->appendXML($tokenReqPayload);
        $body -> appendChild($payload);
        //HACK: End
        // Adding WS-Addressing headers
        $objWSA = new WSASoap($request, WSASoap::WSA_1_0);
        $objWSA->addAction($saction);
        $objWSA->addTo($this->location);
        $objWSA->addMessageID();
        $objWSA->addReplyTo();
        $request = $objWSA->getDoc();
        
		
		// Adding WS-Security headers
        $objWSSE = new WSSESoap($request);
		$objWSSE->signTimestampAndToOnly = TRUE;
        $objWSSE -> addTimestamp(300);
		
		/* create new XMLSec Key using RSA SHA-1 and type is private key */
        $objKey = new XMLSecurityKey(XMLSecurityKey::RSA_SHA1, array('type'=>'private'));
        /* load the private key from file - last arg is bool if key in file (TRUE) or is string (FALSE) */
        $objKey->loadKey($private_key, FALSE);
        /* Sign the message - also signs appropraite WS-Security items */
        $objWSSE->signSoapDoc($objKey);
		
        $token = $objWSSE->addBinaryToken($cert);
        $objWSSE->attachTokentoSig($token);
        	
		$request = $objWSSE->saveXML();
		$this->request = $request;
        $response = $this->__doRequest($request,$this->location,$saction,$this->_soap_version);
        $this->response = $response;

        if ($response == NULL) throw new Exception('No response from STS');
		
        return $rst->processResponse($response);
   }
   
   public function __getLastResponse() {
		return $this->response;
   }
   
   public function __getLastRequest() {
		return $this->request;
   }
}
  
?>
