<?php
header("Content-Type: application/json; charset=UTF-8");

require_once('lib/milestone.php'); 
require_once('client.my.php');

require_once('config.php');

$sts = new STSClient(NULL, array(
							'trace' => 1,
							'location' => $sts_address.'/trust/13/usernamemixed',
                            'uri' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
                            'exceptions' => TRUE,
                            'style'    => SOAP_DOCUMENT,
                            'use'      => SOAP_LITERAL,
                            'soap_version' => SOAP_1_2
							));
							
$sts2 = new STSClient(NULL, array(
							'trace' => 1,
							'location' => $sts_address.'/trust/13/certificatemixed',
                            'uri' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
                            'exceptions' => TRUE,
                            'style'    => SOAP_DOCUMENT,
                            'use'      => SOAP_LITERAL,
                            'soap_version' => SOAP_1_2
                            ));
										 
$service = new mySOAP($DIT_WCF_service_addr.'?wsdl', array(
							'exceptions' => TRUE,
                            'soap_version' => SOAP_1_2,
                            'location' => $DIT_WCF_service_addr.'/ws2007FederationNoSct',
                            'trace' => 1));
										 
										 
$ms = Milestone::getInstance();
										
try {                                         
try {
	$username = 'usernamevraa';
    $password = 'AaVa!}x5d5_iLk';
	
	$claims[] = array('uri' => "http://www.oasis-open.org/RSA2004/attributes/AUTHORITY");
	$claims[] = array('uri' => "http://docs.oasis-open.org/wsfed/authorization/200706/claims/action");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/sid");
	$claims[] = array('uri' => "http://ivis.eps.gov.lv/schema/identity/claims/employeegroup");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name");
	$claims[] = array('uri' => "urn:ivis:100001:name.id-viss");
	
	$cert = file_get_contents('cert/public.pem');
	$private_key = file_get_contents('cert/not_enc.pem');
	
    $tokens = $sts2->issueTokenCert($cert, $private_key, $apply_to, $claims);
      	  
	$ms->addSTSCallmilestone($sts2, $sts_address);
		
    // set Token for service call - we use only first token from collection if many returned
    $service->customtoken = $tokens[0];
	
	$channel_name = 'SampleChannel';
	$channel_urn = 'URN:IVIS:100001:CHA-'.$channel_name.'-TYPE-DIK';
	$minor_v = 0; //version minor value
	$major_v = 1; //version major value
	$channel_version_URN = 'URN:IVIS:100001:CHA-'  .$channel_name. '-v' . $major_v . "-" . $minor_v . '-TYPE-DIK';
	
		
    $dom = new DOMDocument('1.0', 'UTF-8');
	$dom->loadXML(file_get_contents('xml/data.xml')); 

	$req =  array( 
		'MessageSave2' => array(
			'ReceiverFilter' => array(
				'Authority' => array('100001')
			),
			'ChannelVersionURN' => $channel_version_URN,			
			'BussinesMessage' => array(
				'any' => array(
					$dom->saveXML($dom->documentElement)
				)
			)
		)
	);
	
	//sending message
	$method_name = 'SendMessage2';								
	$result = $service->__soapCall($method_name, array($req));
	$ms->addServiceCallMilestone($service, $DIT_WCF_service_addr, $method_name);
		
	if($result->SendMessageResult == true) {
		//authentication with another user credentials
		$tokens = $sts->issueToken($username, $password, $apply_to, $claims);
		$service->customtoken = $tokens[0];
		
		$req_message = array(
			'MessageRequest' => array(
				'ChannelVersionURN' => $channel_version_URN
			)
		);
		
		//receiving messages
		$method_name = 'ReceiveMessage2';								
		$result = $service->__soapCall($method_name, array($req_message));
		$ms->addServiceCallMilestone($service, $DIT_WCF_service_addr, $method_name);
		
		
		$req = array(
			'MessageListRequest' => array(
				'ReadMessage' => true,
				'ChannelVersionURN' => $channel_version_URN
			)
		);
		
		//receiving read messages
		$method_name = 'ReceiveMessageList';								
		$result = $service->__soapCall($method_name, array($req));
		$ms->addServiceCallMilestone($service, $DIT_WCF_service_addr, $method_name);
		
		//if there are read messages
		if($result->MessageBasicInfoList != null) {
			$req = array(
				'MessageBasicInfoList' => $result->MessageBasicInfoList
			);
			
			//restoring messages
			$method_name = 'RestoreMessageList';								
			$result = $service->__soapCall($method_name, array($req));
			$ms->addServiceCallMilestone($service, $DIT_WCF_service_addr, $method_name);
		}
		
		//receiving messages again
		$method_name = 'ReceiveMessage2';								
		$result2 = $service->__soapCall($method_name, array($req_message));
		$ms->addServiceCallMilestone($service, $DIT_WCF_service_addr, $method_name);
		
		//if there are messages
		if($result2->MessageResponse != null && sizeof($result2->MessageResponse) > 0) {
			//iterating over message list
			$i = 0;

			foreach ($result2->MessageResponse as $message) {
				//deleting only 5 first messages if more exist
				$i++;
				if($i > 5) break;
				
				$req = array(
					'MessageRequest' => array(
						'MessageID' => $message->MessageID
					)
				);
			
				//deleting messages
				$method_name = 'DeleteMessage';								
				$result2 = $service->__soapCall($method_name, array($req));
				$ms->addServiceCallMilestone($service, $DIT_WCF_service_addr, $method_name);
			}
		}
	}
	
	
	
	$ms->fromatXML();
	echo $ms->getJSON();
    
} catch (SoapFault $fault) {
	echo $fault;
}
} catch (Exception $ex)  {
	var_dump($ex);
}





?>