<?php
header("Content-Type: application/json; charset=UTF-8");

require_once('lib/milestone.php'); 
require_once('client.my.php');

require_once('config.php');

$sts = new STSClient(NULL, array(
							'trace' => 1,
							'location' => $sts_address.'/trust/13/certificatemixed',
                            'uri' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
                            'exceptions' => TRUE,
                            'style'    => SOAP_DOCUMENT,
                            'use'      => SOAP_LITERAL,
                            'soap_version' => SOAP_1_2
							));
$sts2 = new STSClient(NULL, array(
								'trace' => 1,
								'location' => $sts_address.'/trust/13/usernamemixed',
								'uri' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
								'exceptions' => TRUE,
								'style'    => SOAP_DOCUMENT,
								'use'      => SOAP_LITERAL,
								'soap_version' => SOAP_1_2
								));
										 
$service = new mySOAP($DIT_WCF_service_addr.'?wsdl', array(
							'exceptions' => TRUE,
                            'soap_version' => SOAP_1_2,
                            'location' => $DIT_WCF_service_addr.'/ws2007FederationNoSct',
							'trace' => 1));
							
$service2 = new mySOAP($DIT_WCF_service_addr.'?wsdl', array(
								'exceptions' => TRUE,
								'soap_version' => SOAP_1_2,
								'location' => $DIT_WCF_service_addr.'/ws2007FederationNoSct',
								'trace' => 1));
										 
$ms = Milestone::getInstance();
										
try {                                         
try {
	$claims[] = array('uri' => "http://www.oasis-open.org/RSA2004/attributes/AUTHORITY");
	$claims[] = array('uri' => "http://docs.oasis-open.org/wsfed/authorization/200706/claims/action");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/sid");
	$claims[] = array('uri' => "http://ivis.eps.gov.lv/schema/identity/claims/employeegroup");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name");
	$claims[] = array('uri' => "urn:ivis:100001:name.id-viss");
	
    $cert = file_get_contents('cert/public.pem');
	$private_key = file_get_contents('cert/not_enc.pem');
	
    $tokens = $sts->issueTokenCert($cert, $private_key, $apply_to, $claims);
      	  
	$ms->addSTSCallmilestone($sts, $sts_address);
		
    // set Token for service call - we use only first token from collection if many returned
	$service->customtoken = $tokens[0];
	
	$channel_name = 'SampleChannel';
	$channel_urn = 'URN:IVIS:100001:CHA-'.$channel_name.'-TYPE-DIK';
	$minor_v = 0; //version minor value
	$major_v = 1; //version major value
	$channel_version_URN = 'URN:IVIS:100001:CHA-'  .$channel_name. '-v' . $major_v . "-" . $minor_v . '-TYPE-DIK';
	
	
    $dom = new DOMDocument('1.0', 'UTF-8');
	$dom->loadXML(file_get_contents('xml/data.xml')); 

	$req =  array( 
		'MessageSave2' => array(
			'ReceiverFilter' => array(
				'Authority' => array('100001')
			),
			'ChannelVersionURN' => $channel_version_URN,			
			'BussinesMessage' => array(
				'any' => array(
					$dom->saveXML($dom->documentElement)
				)
			)
		)
	);

	$method_name = 'SendMessage2';
	$result2 = $service->__soapCall($method_name, array($req));
	$ms->addServiceCallMilestone($service, $DIT_WCF_service_addr, $method_name);



	// set UsernameToken variables and request for tokens
	$username = 'usernamevraa';
	$password = 'AaVa!}x5d5_iLk';
	 
	$tokens = $sts2->issueToken($username, $password, $apply_to, $claims);
			 
	$ms->addSTSCallmilestone($sts2, $sts_address);
		 
	 // set Token for service call - we use only first token from collection if many returned
	$service2->customtoken = $tokens[0];	 
 
	$req = array(
		 'MessageRequest' => array(
			 'ChannelURN' => $channel_urn
	 	)
	);
	 
	$method_name = 'ReceiveMessage2';								
	$result = $service2->__soapCall($method_name, array($req));
	$ms->addServiceCallMilestone($service2, $DIT_WCF_service_addr, $method_name);

	$messageId = $result->MessageResponse2->Items[0]->MessageID;


	$dom = new DOMDocument('1.0', 'UTF-8');
	$dom->loadXML(file_get_contents('xml/kluda.xml')); 

	$req =  array( 
		'MessageSave2' => array(
			'ChannelVersionURN' => $channel_version_URN,			
			'EventMessage' => array(
				'any' => array(
					$dom->saveXML($dom->documentElement)
				),
				'Name' => 'Error!',
				'RelatedMessageID' => $messageId
			)
		)
	);

	$method_name = 'SendMessage2';
	//$result2 = $service->__soapCall($method_name, array($req));
	//$ms->addServiceCallMilestone($service, $DIT_WCF_service_addr, $method_name);

	$ms->fromatXML();
	echo $ms->getJSON();
    
} catch (SoapFault $fault) {
	echo $fault;
}
} catch (Exception $ex)  {
	var_dump($ex);
}

?>