/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package lv.abcsoftware.eves.samples.sendmessage;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.BindingProvider;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.DITConfigurationService;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.IDITConfigurationServiceContract;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertChannel;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertChannelVersion;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchChannelVersionsPaged;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchChannelVersionsPagedResponse;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchChannelsPaged;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SendMessageResponse;
import lv.gov.eps.ivis.iss.ditservice.v1_0.IDITMessageServiceContract;
import lv.gov.eps.ivis.iss.ditservice.v1_0.SendMessage;
import lv.gov.eps.ivis.iss.ditservice.v1_0.DITMessageService;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.BussinesMessageType;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelSearchInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelType;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelVersionInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelVersionSearchInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageClassInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageSaveStructure2;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageTypeInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100001.ivis.v1_0.AuthorityBasicInfoStructure;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SendMessageToChannelVersion {

    public static void main(String[] args) {

        SpringBusFactory bf = new SpringBusFactory();
        BusFactory.setDefaultBus(bf.createBus("ProxyToService/src/main/resources/client-cert.xml"));

        DITConfigurationService service = new DITConfigurationService();
        IDITConfigurationServiceContract port = service.getWs2007FederationNoSct();
        Map<String, Object> ctx = ((BindingProvider) port).getRequestContext();
        ctx.put("ws-security.username", "DitAdmin");
        ctx.put("ws-security.password", "AaVa!}x5d5_iLk");


        String channelName = "SampleChannel";
        String channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
        String channelVersionURN = "URN:IVIS:100001:CHA-SampleChannel-v1-0-TYPE-DIK";

        SearchChannelsPaged searchChannelsPaged = new SearchChannelsPaged();
        ChannelSearchInfoStructure request = new ChannelSearchInfoStructure();
        searchChannelsPaged.setChannelSearch(request);

        ChannelInfoStructure channel = new ChannelInfoStructure();
        request.setChannel(channel);

        channel.setChannelURN(channelURN);
        request.setOnlyHeader(true);

        SendMessageResponse sendMessageResponse = port.searchChannelsPaged(searchChannelsPaged);

        ChannelInfoStructure newChannel = new ChannelInfoStructure();
        newChannel.setShortName(channelName);
        newChannel.setChannelURN(channelURN);
        newChannel.setChannelType(ChannelType.DIK);
        newChannel.setOwnerAuthority(new AuthorityBasicInfoStructure());
        newChannel.getOwnerAuthority().setAuthorityID("100000");
        newChannel.setChannelName(channelName);

        if (sendMessageResponse.getChannelList().getCount() == 0) {
            InsertChannel insertChannel = new InsertChannel();
            insertChannel.setChannel(channel);
            int channelId = port.insertChannel(insertChannel).getInsertChannelResponse();
            System.out.println("Channel created");
        } else {
            System.out.println("Channel found");
        }

        ChannelVersionInfoStructure channelVersion = new ChannelVersionInfoStructure();

        MessageTypeInfoStructure messageType = new MessageTypeInfoStructure();
        messageType.setMessageClass(new MessageClassInfoStructure());
        messageType.getMessageClass().setCodeListCodeValue("1");
        messageType.setXMLSchemaURN("URN:IVIS:100001:XSD-Person-FullName-v1-0-TYPE-PersonFullName");

        MessageTypeInfoStructure messageType1 = new MessageTypeInfoStructure();
        messageType1.setMessageClass(new MessageClassInfoStructure());
        messageType1.getMessageClass().setCodeListCodeValue("3");
        messageType1.setXMLSchemaURN("URN:IVIS:100001:XSD-DIT-DITMessage-v1-0-TYPE-DefaultMessageError");

        channelVersion.getMessageType().add(messageType);
        channelVersion.getMessageType().add(messageType1);


        channelVersion.getChannelVersionStatus().add("active");

        channelVersion.setChannel(channel);
        channelVersion.setMinorVersion((short) 0);
        channelVersion.setMajorVersion((short) 1);

        ChannelVersionSearchInfoStructure channelVersionSearch = new ChannelVersionSearchInfoStructure();
        channelVersionSearch.setChannelVersion(channelVersion);

        SearchChannelVersionsPaged searchChannelVersionsPaged = new SearchChannelVersionsPaged();
        searchChannelVersionsPaged.setChannelVersionSearch(channelVersionSearch);
        SearchChannelVersionsPagedResponse channelVersions = port.searchChannelVersionsPaged(searchChannelVersionsPaged);

        if (channelVersions.getChannelVersionsList().getCount() == 0) {
            InsertChannelVersion insertChannelVersion = new InsertChannelVersion();
            insertChannelVersion.setChannelVersionData(channelVersion);
            int channelId = port.insertChannelVersion(insertChannelVersion).getInsertChannelVersionResponse();
            System.out.println("Channel version created");
        } else {
            System.out.println("Channel version found");
        }

        DITMessageService dITService = new DITMessageService();

        IDITMessageServiceContract ditClient = dITService.getWs2007FederationNoSct();
        Map<String, Object> ditCtx = ((BindingProvider) ditClient).getRequestContext();
        /*ditCtx.put("ws-security.username", "DitAdmin");
        ditCtx.put("ws-security.password", "password");*/


        MessageSaveStructure2 message = new MessageSaveStructure2();
        message.setChannelVersionURN(channelVersionURN);
        BussinesMessageType bussinesMessage = new BussinesMessageType();
        message.setBussinesMessage(bussinesMessage);

        Object obj = getObject();
        bussinesMessage.setAny(obj);

        SendMessage sendMessage = new SendMessage();
        sendMessage.setMessageSave2(message);

        lv.gov.eps.ivis.iss.ditservice.v1_0.SendMessageResponse sendMessageResponse1 = ditClient.sendMessage2(sendMessage);
        System.out.println("Message Sent : " + sendMessageResponse1.isSendMessageResult());

    }

    static Object getObject() {
        try {
            File fXmlFile = new File("data.xml");

            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();

            Element e = doc.getDocumentElement();
            return e;

        } catch (SAXException ex) {
            Logger.getLogger(SendMessageToChannelVersion.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(SendMessageToChannelVersion.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(SendMessageToChannelVersion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}
