package lv.abcsoftware.eves.samples.ackstatuschange;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.BindingProvider;

import lv.gov.eps.ivis.iss.ditservice.v1_0.*;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.*;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ACKStatusChange {

    public static void main(String[] args) {
        String channelName = "SampleChannel";
        String channelVersionURN = "URN:IVIS:100001:CHA-" + channelName + "-v1-0-TYPE-DIK";
        sendMessage2(channelVersionURN);
        receiveMessage2(channelName, channelVersionURN);
    }

    private static void receiveMessage2(String channelName, String channelVersionURN) {
        SpringBusFactory bf = new SpringBusFactory();
        BusFactory.setDefaultBus(bf.createBus("ProxyToService/src/main/resources/client-username.xml"));

        DITMessageService dITService = new DITMessageService();

        IDITMessageServiceContract ditClient = dITService.getWs2007FederationNoSct();
        Map<String, Object> ditCtx = ((BindingProvider) ditClient).getRequestContext();
        ditCtx.put("ws-security.username", "username3");
        ditCtx.put("ws-security.password", "_%qTpgPA9Z_qMJ");

        MessageRequestStructure messageRequest = new MessageRequestStructure();
        messageRequest.setChannelVersionURN(channelVersionURN);

        lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessage request = new lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessage();
        request.setMessageRequest(messageRequest);

        ReceiveMessageResponse response = ditClient.receiveMessage2(request);
        System.out.println("Message received: " + response.getMessageResponse2().getBussinesMessageOrEventMessageTypeOrMessage());
        String messageId = response.getMessageResponse2().getBussinesMessageOrEventMessageTypeOrMessage().get(0).getMessageID();
        ConfirmationAck confirmationAck = new ConfirmationAck();
        confirmationAck.setMessageSampleId(messageId);
        ditClient.confirmationAck(confirmationAck);
    }

    private static void sendMessage2(String channelVersionURN){
        SpringBusFactory bf = new SpringBusFactory();
        BusFactory.setDefaultBus(bf.createBus("../ProxyToService/src/main/resources/client-cert.xml"));

        DITMessageService dITService = new DITMessageService();

        IDITMessageServiceContract ditClient = dITService.getWs2007FederationNoSct();
        Map<String, Object> ditCtx = ((BindingProvider) ditClient).getRequestContext();

        MessageSaveStructure2 message = new MessageSaveStructure2();
        message.setChannelVersionURN(channelVersionURN);
        BussinesMessageType bussinesMessage = new BussinesMessageType();
        message.setBussinesMessage(bussinesMessage);

        Object obj = getObject("data.xml");
        bussinesMessage.setAny(obj);

        SendMessage sendMessage = new SendMessage();
        sendMessage.setMessageSave2(message);

        lv.gov.eps.ivis.iss.ditservice.v1_0.SendMessageResponse sendMessageResponse1 = ditClient.sendMessage2(sendMessage);
        System.out.println("Message Sent : " + sendMessageResponse1.isSendMessageResult());
    }

    static Object getObject(String pathName) {
        try {
            File fXmlFile = new File(pathName);

            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();

            Element e = doc.getDocumentElement();
            return e;

        } catch (SAXException ex) {
            Logger.getLogger(ACKStatusChange.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(ACKStatusChange.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(ACKStatusChange.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}
