﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//    Copyright © ABC SOFTWARE. All rights reserved.
//    The source code or its parts to use, reproduce, transfer, copy or
//    keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.SelectAndCreateChannel
{
    using System;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using ProxyToService;
    using System.Linq;
    using ProxyToService.DitConfiguration;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            using (ProxyToService.DitConfiguration.DITConfigurationServiceContractClient client = new ProxyToService.DitConfiguration.DITConfigurationServiceContractClient("ConfigurationService"))
            {
                try
                {
                    string channelName = "SampleChannel";
                    string chType = "DIK";
                    string channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-" + chType;
                    ProxyToService.DitConfiguration.ChannelSearchInfoStructure req = new ProxyToService.DitConfiguration.ChannelSearchInfoStructure();
                    req.Channel = new ProxyToService.DitConfiguration.ChannelInfoStructure();
                    req.Channel.ChannelURN = channelURN;
                    req.OnlyHeader = true;
                    ProxyToService.DitConfiguration.ChannelListStructure channels = Helper.InvokeIgnoreException<ChannelListStructure, CommunicationException>(() => client.SearchChannelsPaged(req, ChannelVersionStatusType.testing), "Argument exception: ChannelURN!");
                    ChannelInfoStructure channel = new ChannelInfoStructure();
                    channel.ShortName = channelName;
                    channel.ChannelURN = channelURN;
                    channel.ChannelType = ChannelType.dik;
                    channel.OwnerAuthority = new AuthorityBasicInfoStructure();
                    channel.OwnerAuthority.AuthorityID = "100000";
                    channel.OwnerAuthority.ShortName = "ABC";
                    channel.OwnerAuthority.Name = "ABC Software";
                    channel.ChannelName = channelName;
                    channel.ChannelTypeSpecified = true;

                    bool channelExsists = channels != null && channels.Count > 0;
                    if (!channelExsists)
                    {
                        int channelId = client.InsertChannel(channel);
                        Console.WriteLine("Channel created");
                    }
                    else
                    {
                        Console.WriteLine("Channel found");
                    }

                    ChannelVersionInfoStructure channelVersion = new ChannelVersionInfoStructure();
                    channelVersion.MessageType = new MessageTypeInfoStructure[3];
                    channelVersion.MessageType[0] = new MessageTypeInfoStructure
                    {
                        MessageClass = new MessageClassInfoStructure()
                    };
                    channelVersion.IsManualAckSpecified = true;
                    channelVersion.IsManualAck = false;

                    channelVersion.UseReceiverFilterSpecified = true;
                    channelVersion.UseReceiverFilter = true;

                    // 1 Biznesa ziņojums
                    // 2 Transakcijas ziņojums
                    // 3 error
                    channelVersion.MessageType[0].MessageClass.CodeListCodeValue = "2";
                    channelVersion.MessageType[0].XMLSchemaURN = "URN:IVIS:100001:XSD-Ditlog-DITLog-v1-0-TYPE-DITLog";

                    channelVersion.MessageType[1] = new MessageTypeInfoStructure
                    {
                        MessageClass = new MessageClassInfoStructure()
                    };
                    channelVersion.MessageType[1].MessageClass.CodeListCodeValue = "3";
                    channelVersion.MessageType[1].XMLSchemaURN = "URN:IVIS:100001:XSD-DIT-DITMessage-v1-0-TYPE-DefaultMessageError";

                    channelVersion.ChannelVersionStatus = ChannelVersionStatusType.active;
                    channelVersion.ChannelVersionStatusSpecified = true;

                    channelVersion.Channel = channel;
                    channelVersion.MinorVersionSpecified = true;
                    channelVersion.MinorVersion = 0;
                    channelVersion.MajorVersionSpecified = true;
                    channelVersion.MajorVersion = 1;
                    channelVersion.ChannelVersionURN = "URN:IVIS:100001:CHA-" + channelName + "-v" + channelVersion.MajorVersion + "-" + channelVersion.MinorVersion + "-TYPE-" + chType;

                    ChannelVersionSearchInfoStructure channelVersionSearch = new ChannelVersionSearchInfoStructure();
                    channelVersionSearch.ChannelVersion = new ChannelVersionInfoStructure();
                    channelVersionSearch.ChannelVersion = channelVersion;

                    ChannelVersionListStructure channelVersions = client.SearchChannelVersionsPaged(channelVersionSearch);
                    if (channelVersions.Count == 0)
                    {
                        
                        int channelId = client.InsertChannelVersion(channelVersion);
                        Console.WriteLine("Channel version created");
                    }
                    else
                    {
                        Console.WriteLine("Channel version found");
                    }

                    string channelVersionURN = channelVersion.ChannelVersionURN;
                    ChannelSubscriberInfoStructure channelSubscriber = new ChannelSubscriberInfoStructure();
                    channelSubscriber.ChannelVersionURN = channelVersionURN;
                    channelSubscriber.SubscriberAuthority = new AuthorityBasicInfoStructure();
                    channelSubscriber.SubscriberAuthority.AuthorityID = "100001";
                    channelSubscriber.SubscriberAuthority.ShortName = "VRAA";
                    channelSubscriber.SubscriberAuthority.Name = "VRAA";
                    ChannelSubscriberSearchInfoStructure channelSubscriberSearch = new ChannelSubscriberSearchInfoStructure();
                    channelSubscriberSearch.ChannelSubscriber = channelSubscriber;
                    ChannelSubscriberListStructure channelSubscriberList = client.SearchSubscribersToChannelPaged(channelSubscriberSearch);
                    if (channelSubscriberList.Count == 0)
                    {
                        int result = client.InsertSubscriberToChannel(channelSubscriber);
                        Console.WriteLine("Channel subscriber created");
                    }
                    else
                    {
                        Console.WriteLine("Channel subscriber found");
                    }

                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }
    }
}