﻿namespace Viss.DIT.WS.Samples.ProxyToService
{
    using System;

    public class Helper
    {
        public static TResult InvokeIgnoreException<TResult, TException>(Func<TResult> func, string ignoreMessage = null) where TException : Exception
        {
            TResult result = default(TResult);
            try
            {
                result = func();
            }
            catch (TException exception)
            {
                if (ignoreMessage == null || !exception.Message.Contains(ignoreMessage))
                {
                    throw;
                }
            }
            return result;
        }
    }
}
