﻿// ---------------------------------------------------------------------------- 
// <copyright file="Program.cs" company="ABC software">
//     Copyright © ABC SOFTWARE. All rights reserved. The source code or its parts to use,
//     reproduce, transfer, copy or keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------  

namespace Viss.DIT.WS.Samples.FTPs_ReceiveMessage
{
    using System;
    using System.Globalization;
    using System.IO;
    using System.Net;
    using System.Net.FtpClient;
    using System.Security.Principal;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// class Program 
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args. 
        /// </summary>
        /// <param name="args"> The args. </param>
        public static void Main(string[] args)
        {
            var interval = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Interaval"));
            string ftpAdress = System.Configuration.ConfigurationManager.AppSettings.Get("FtpAdress");
            int port = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("FtpPort"));
            var userName = System.Configuration.ConfigurationManager.AppSettings.Get("UserName");
            var password = System.Configuration.ConfigurationManager.AppSettings.Get("Password");
            var folder = System.Configuration.ConfigurationManager.AppSettings.Get("FolderTemp");

            long ss = 0;

            Console.WriteLine("Press Enter");
            while (true)
            {
                try
                {
                    Thread.Sleep(interval);

                    var t = Task.Factory.StartNew(() =>
                    {
                        using (var ftpClient = new System.Net.FtpClient.FtpClient())
                        {
                            ftpClient.Host = ftpAdress;
                            ftpClient.EncryptionMode = System.Net.FtpClient.FtpEncryptionMode.Explicit;
                            ftpClient.Port = Convert.ToInt32(port, CultureInfo.InvariantCulture);
                            ftpClient.Credentials = new NetworkCredential(userName, password);
                            ftpClient.ReadTimeout = 5000;

                            string folderName = "/SampleChannel/DIK-v1-0/ReadError";
                            DirectoryInfo dir = new DirectoryInfo(folder);

                            var ss1 = dir.GetFiles();

                            if (ss1 != null)
                            {
                                foreach (var item in ss1)
                                {
                                    item.Delete();
                                }
                            }

                            ftpClient.SetWorkingDirectory(folderName);

                            ftpClient.ValidateCertificate += new System.Net.FtpClient.FtpSslValidation(myCertificateValidation);

                            foreach (var item in ftpClient.GetListing(ftpClient.GetWorkingDirectory()))
                            {
                                switch (item.Type)
                                {
                                    case FtpFileSystemObjectType.Directory:
                                        Console.WriteLine("Folder:" + item.Name);
                                        break;

                                    case FtpFileSystemObjectType.File:

                                        GetFile(ftpClient, item.FullName, item.Name, dir);

                                        Console.WriteLine("File:" + item.Name);
                                        break;
                                }
                            }

                            FileInfo[] fileInfo = dir.GetFiles();

                            foreach (var item in fileInfo)
                            {
                                Console.WriteLine(item.Name + " received");
                            }

                            ss++;

                            Console.WriteLine(ss);
                        }
                    });

                    t.Wait();
                }
                catch (Exception e)
                {
                    Thread.Sleep(3000);
                    string mess = e.Message;
                    Console.WriteLine(mess);
                }
            }

        }

        /// <summary>
        /// Gets the file. 
        /// </summary>
        /// <param name="ftpClient"> The FTP client. </param>
        /// <param name="fileName">  Name of the file. </param>
        /// <param name="dirToSave"> The dir to save. </param>
        private static void GetFile(System.Net.FtpClient.FtpClient ftpClient, string fileNameFullName, string fileName, DirectoryInfo dirToSave)
        {
            string userID = WindowsIdentity.GetCurrent().Name;

            using (var ftpStream = ftpClient.OpenRead(fileNameFullName))

            using (var fileStream = new FileStream(new FileInfo(dirToSave.FullName + fileName).FullName, FileMode.OpenOrCreate))
            {
                var buffer = new byte[8 * 1024];
                int count;
                while ((count = ftpStream.Read(buffer, 0, buffer.Length)) > 0)
                {
                    fileStream.Write(buffer, 0, count);
                }

            }
        }

        // callback used to validate the certificate in an SSL conversation 
        private static void myCertificateValidation(System.Net.FtpClient.FtpClient control, System.Net.FtpClient.FtpSslValidationEventArgs e)
        {
            e.Accept = true;
        }
    }
}