﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//    Copyright © ABC SOFTWARE. All rights reserved.
//    The source code or its parts to use, reproduce, transfer, copy or
//    keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.SendMessageToChannelVersion
{
    using System;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using ProxyToService;
    using ProxyToService.DitService;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            string channelName = "SampleChannel";
            string channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
            //string channelVersionURN = "URN:IVIS:100001:CHA-" + channelName + "-v1-0-TYPE-DIK";

            using (ProxyToService.DitService.DITMessageServiceContractClient client = new ProxyToService.DitService.DITMessageServiceContractClient("MessageService"))
            {
                try
                {

                    MessageRequestStructure messDelete = new MessageRequestStructure();
                    messDelete.Item = channelURN;

                    bool resp = client.DeleteMessage(messDelete);

                    Console.WriteLine("message was deleted");
                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }
    }
}