<?php
header("Content-Type: text/html; charset=UTF-8");

/** 
 * client.php 
 * 
 * Copyright (c) 2010, ABC Software SIA <abcsoftware@abcsoftware.lv>. 
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 *   * Redistributions of source code must retain the above copyright 
 *     notice, this list of conditions and the following disclaimer. 
 * 
 *   * Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the 
 *     distribution. 
 * 
 *   * Neither the name of Sergejs Degtjars nor the names of his 
 *     contributors may be used to endorse or promote products derived 
 *     from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE. 
 * 
 * @author     Sergejs Degtjars <sergejs.degtjars@abcsoftware.lv> 
 * @copyright  2010 ABC Software SIA <abcsoftware@abcsoftware.lv> 
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License 
 * @version    0.1.0  alpha
 */
require_once('lib/sts_client.php');
require_once('lib/wsse/soap-wsa.php');
require_once('lib/wsse/soap-wsse.php');
require_once('lib/SAMLProcessing.php'); 


class mySOAP extends SoapClient {
    public $customtoken;
    
    function __doRequest($request, $location, $saction, $version, $one_way = NULL) {
        $dom = new DOMDocument();
        $dom->loadXML($request);

        $objWSA = new WSASoap($dom, WSASoap::WSA_1_0);
        $objWSA->addAction($saction);
        $objWSA->addMessageID();
        $objWSA->addReplyTo();
        $objWSA->addTo($location);
        $dom = $objWSA->getDoc();
        
        $objWSSE = new WSSESoap($dom);
        $objWSSE->addTimestamp();
        // signing TimeStamp
        /* create new XMLSec Key using HMAC-SHA1 and type is public key */
        $objKey = new XMLSecurityKey(XMLSecurityKey::HMAC_SHA1, array('type'=>'public'));
        
        /* load the private key from file - last arg is bool if key in file (TRUE) or is string (FALSE) */
        $objKey->Key = $this->customtoken['key'];
        
        /* Sign the message - also signs appropraite WS-Security items */
        $objWSSE->signTimestampOnly = TRUE;
        $options = array("insertBefore" => FALSE);
        $objWSSE->signSoapDoc($objKey, $options);
        $objWSSE->attachReftoSig($this->customtoken['arkeyid']);
        // Adding Endorsed token
        
		//Hack by Maksims Markovs : adding placeholder to inject raw sts token content into service request
		$placeholder = '<tokenplaceholder/>';
		$objWSSE->addCustomTokenPlaceholder($placeholder);
        
		$request = $objWSSE->saveXML();
		
		//Hack by Maksims Markovs	
        $request = str_replace($placeholder,  $this->customtoken['token'], $request);		
        $response = parent::__doRequest($request, $location, $saction, $version);
		
		return $response;
    }
}


?>
