/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package lv.abcsoftware.eves.samples.createsubscriber;

import java.util.Map;
import javax.xml.ws.BindingProvider;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.DITConfigurationService;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.IDITConfigurationServiceContract;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertChannel;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertChannelResponse;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertChannelVersion;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertChannelVersionResponse;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertSubscriberToChannel;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchChannelVersionsPaged;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchChannelVersionsPagedResponse;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchChannelsPaged;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchSubscribersToChannelPaged;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchSubscribersToChannelPagedResponse;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SendMessageResponse;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelSearchInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelSubscriberInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelSubscriberSearchInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelType;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelVersionInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelVersionSearchInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageClassInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageTypeInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100001.ivis.v1_0.AuthorityBasicInfoStructure;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;

public class CreateSubscriberToChannelVersion {

    public static void main(String[] args) {
        SpringBusFactory bf = new SpringBusFactory();        
        BusFactory.setDefaultBus(bf.createBus("ProxyToService/src/main/resources/client-cert.xml"));

        String channelName = "SampleChannel";
        String channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
        String channelVersionURN = "URN:IVIS:100001:CHA-SampleChannel-v1-0-TYPE-DIK";

        DITConfigurationService service = new DITConfigurationService();
        IDITConfigurationServiceContract port = service.getWs2007FederationNoSct();

        Map<String, Object> ctx = ((BindingProvider) port).getRequestContext();
        /*ctx.put("ws-security.username", "DitAdmin");
        ctx.put("ws-security.password", "password");*/

        ChannelSearchInfoStructure req = new ChannelSearchInfoStructure();

        req.setChannel(new ChannelInfoStructure());
        req.getChannel().setChannelURN(channelURN);
        req.setOnlyHeader(true);

        SearchChannelsPaged searchChannelsPaged = new SearchChannelsPaged();
        searchChannelsPaged.setChannelSearch(req);
        SendMessageResponse sendMessageResponse = port.searchChannelsPaged(searchChannelsPaged);

        ChannelInfoStructure channel = new ChannelInfoStructure();
        channel.setShortName(channelName);
        channel.setChannelURN(channelURN);
        channel.setChannelType(ChannelType.DIK);
        channel.setOwnerAuthority(new AuthorityBasicInfoStructure());
        channel.getOwnerAuthority().setAuthorityID("100000");
        channel.setChannelName(channelName);

        if (sendMessageResponse.getChannelList().getCount() == 0) {
            InsertChannel insertChannel = new InsertChannel();
            insertChannel.setChannel(channel);
            InsertChannelResponse insertChannelResponse = port.insertChannel(insertChannel);

            int id = insertChannelResponse.getInsertChannelResponse();
            System.out.println("Channel created " + id);
        } else {
            System.out.println("Channel found");
        }

        ChannelVersionInfoStructure channelVersion = new ChannelVersionInfoStructure();

        // 1 Biznesa ziņojums
        // 2 Transakcijas ziņojums 
        // 3 error

        MessageTypeInfoStructure messageType = new MessageTypeInfoStructure();
        messageType.setMessageClass(new MessageClassInfoStructure());
        messageType.getMessageClass().setCodeListCodeValue("1");
        messageType.setXMLSchemaURN("URN:IVIS:100001:XSD-Person-FullName-v1-0-TYPE-PersonFullName");

        MessageTypeInfoStructure messageType1 = new MessageTypeInfoStructure();
        messageType1.setMessageClass(new MessageClassInfoStructure());
        messageType1.getMessageClass().setCodeListCodeValue("3");
        messageType1.setXMLSchemaURN("URN:IVIS:100001:XSD-DIT-DITMessage-v1-0-TYPE-DefaultMessageError");

        channelVersion.getMessageType().add(messageType);
        channelVersion.getMessageType().add(messageType1);

        channelVersion.getChannelVersionStatus().add("active");
        // channelVersion.setChannelVersionStatus();
        // channelVersion.ChannelVersionStatusSpecified = true;

        channelVersion.setChannel(channel);
        channelVersion.setMinorVersion((short) 0);
        channelVersion.setMajorVersion((short) 1);

        ChannelVersionSearchInfoStructure channelVersionSearch = new ChannelVersionSearchInfoStructure();
        channelVersionSearch.setChannelVersion(channelVersion);

        SearchChannelVersionsPaged searchChannelVersionsPaged = new SearchChannelVersionsPaged();
        searchChannelVersionsPaged.setChannelVersionSearch(channelVersionSearch);

        SearchChannelVersionsPagedResponse channelVersions = port.searchChannelVersionsPaged(searchChannelVersionsPaged);

        if (channelVersions.getChannelVersionsList().getCount() == 0) {
            InsertChannelVersion insertChannelVersion = new InsertChannelVersion();
            insertChannelVersion.setChannelVersionData(channelVersion);
            InsertChannelVersionResponse insertChannelVersionResponse = port.insertChannelVersion(insertChannelVersion);
            int channelId = insertChannelVersionResponse.getInsertChannelVersionResponse();
            System.out.println("Channel version created");
        } else {
            System.out.println("Channel version found");
        }

        ChannelSubscriberInfoStructure channelSubscriber = new ChannelSubscriberInfoStructure();
        channelSubscriber.setChannelVersionURN(channelVersionURN);
        channelSubscriber.setSubscriberAuthority(new AuthorityBasicInfoStructure());
        channelSubscriber.getSubscriberAuthority().setAuthorityID("100001");
        ChannelSubscriberSearchInfoStructure channelSubscriberSearch = new ChannelSubscriberSearchInfoStructure();
        channelSubscriberSearch.setChannelSubscriber(channelSubscriber);

        SearchSubscribersToChannelPaged request = new SearchSubscribersToChannelPaged();
        request.setChannelSubscriberSearch(channelSubscriberSearch);
        SearchSubscribersToChannelPagedResponse searchSubscribersToChannelPagedResponse = port.searchSubscribersToChannelPaged(request);

        if (searchSubscribersToChannelPagedResponse.getChannelSubscriberList().getCount() == 0) {
            InsertSubscriberToChannel insertRequest = new InsertSubscriberToChannel();
            insertRequest.setChannelSubscriber(channelSubscriber);
            int result = port.insertSubscriberToChannel(insertRequest).getInsertSubscriberToChannelResponse();
            System.out.println("Channel subscriber created status: " + result );
        } else {
            System.out.println("Channel subscriber found");
        }
    }
}
