﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//    Copyright © ABC SOFTWARE. All rights reserved.
//    The source code or its parts to use, reproduce, transfer, copy or
//    keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.SelectAndCreateChannel
{
    using System;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using ProxyToService;
    using ProxyToService.DitConfiguration;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            using (ProxyToService.DitConfiguration.DITConfigurationServiceContractClient client = new ProxyToService.DitConfiguration.DITConfigurationServiceContractClient("ConfigurationService"))
            {
                try
                {
                    const string channelName = "SampleChannel";
                    string channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
                   
                    ProxyToService.DitConfiguration.ChannelSearchInfoStructure req = new ProxyToService.DitConfiguration.ChannelSearchInfoStructure
                    {
                        Channel = new ProxyToService.DitConfiguration.ChannelInfoStructure
                        {
                            ChannelURN = channelURN
                        },

                        OnlyHeader = true
                    };

                    ProxyToService.DitConfiguration.ChannelListStructure channels = Helper.InvokeIgnoreException<ChannelListStructure, CommunicationException>(() => client.SearchChannelsPaged(req, ChannelVersionStatusType.testing), "Argument exception: ChannelURN!"); 
                    bool channelExsists = channels != null && channels.Count > 0;

                    if (!channelExsists)
                    {
                        Console.WriteLine("Channel creation...");

                        ChannelInfoStructure channel = new ChannelInfoStructure();
                        channel.ShortName = channelName;
                        channel.ChannelURN = channelURN;
                        channel.ChannelType = ChannelType.dik;
                        channel.OwnerAuthority = new AuthorityBasicInfoStructure();
                        channel.OwnerAuthority.AuthorityID = "100000";
                        channel.OwnerAuthority.ShortName = "ABC";
                        channel.OwnerAuthority.Name = "ABC Software";
                        channel.ChannelName = channelName;
                        channel.ChannelTypeSpecified = true;

                        int channelId = client.InsertChannel(channel);

                        Console.WriteLine("Channel is created");
                    }
                    else
                    {
                        Console.WriteLine("Channel is found");
                    }

                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }

        
    }
}