﻿// -----------------------------------------------------------------------
// <copyright file="ApplyToClientCredentialsSecurityTokenManager.cs" company="">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.ProxyToService
{
    using System.IdentityModel.Selectors;
    using System.ServiceModel;
    using System.ServiceModel.Channels;
    using System.ServiceModel.Security.Tokens;
    using Microsoft.IdentityModel.Protocols.WSTrust;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    internal class ApplyToClientCredentialsSecurityTokenManager : ClientCredentialsSecurityTokenManager
    {
        private readonly ApplyToClientCredentials applyToClientCredentials;

        public ApplyToClientCredentialsSecurityTokenManager(ApplyToClientCredentials clientCredentials)
            : base(clientCredentials)
        {
            this.applyToClientCredentials = clientCredentials;
        }

        public override SecurityTokenProvider CreateSecurityTokenProvider(SecurityTokenRequirement tokenRequirement)
        {
            if (!this.IsIssuedSecurityTokenRequirement(tokenRequirement))
            {
                return base.CreateSecurityTokenProvider(tokenRequirement);
            }

            var provider = base.CreateSecurityTokenProvider(tokenRequirement);
            if (provider is SimpleSecurityTokenProvider)
            {
                return provider;
            }

            var issuedProvider = provider as IssuedSecurityTokenProvider;
            if (issuedProvider != null)
            {
                if (this.applyToClientCredentials.ApplyTo != null)
                {
                    issuedProvider.TargetAddress = new EndpointAddress(this.applyToClientCredentials.ApplyTo, new AddressHeader[0]);
                }

                return new FederatedSecurityTokenProvider(new FederatedClientCredentialsParameters(), issuedProvider);
            }

            return provider;
        }
    }
}