﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//    Copyright © ABC SOFTWARE. All rights reserved.
//    The source code or its parts to use, reproduce, transfer, copy or
//    keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.LoginUserName
{
    using System;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using ProxyToService;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            using (ProxyToService.DitConfiguration.DITConfigurationServiceContractClient client = new ProxyToService.DitConfiguration.DITConfigurationServiceContractClient("ConfigurationService"))
            {
                try
                {
                    //var applyTo = new Uri("https://ivis.eps.gov.lv/DIT.WebService");
                    //var factory = client.ChannelFactory;
                    //var other = factory.Endpoint.Behaviors.Find<ClientCredentials>();
                    //factory.Endpoint.Behaviors.Remove(other.GetType());
                    //var item = new ApplyToClientCredentials(other) { ApplyTo = applyTo };
                    //factory.Endpoint.Behaviors.Add(item);
                    var postBox = client.SelectPostBox("100000");

                    if (postBox != null)
                    {
                        Console.WriteLine(postBox.Authority.ShortName);
                    }

                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }
    }
}