﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//     Copyright © ABC SOFTWARE. All rights reserved. The source code or its parts to use,
//     reproduce, transfer, copy or keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.FTPs_SendMessage
{
    using FluentFTP;
    using System;
    using System.Collections.Generic;
    using System.Globalization;
    using System.IO;
    using System.Net;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args"> The args. </param>
        public static void Main(string[] args)
        {
            Dictionary<string, int> fileSendDic = new Dictionary<string, int>();
            fileSendDic.Add("../../../DIT10MB.xml", 2);
            string channelName = "SampleChannel";

            foreach (var item in fileSendDic)
            {
                for (int i = 0; i < item.Value; i++)
                {
                    UploadFileToFtp(new FileInfo(item.Key), channelName, i);
                    Console.WriteLine(i);
                }
            }

            Console.ReadLine();

        }

        public static void UploadFileToFtp(FileInfo fileInfo, string channelName,int i)
        {
            if (fileInfo == null)
            {
                throw new ArgumentException("fileInfo is null");
            }

            var ftpAdress = System.Configuration.ConfigurationManager.AppSettings.Get("FtpAdress");
            var port = System.Configuration.ConfigurationManager.AppSettings.Get("FtpPort");
            var userName = System.Configuration.ConfigurationManager.AppSettings.Get("UserName");
            var password = System.Configuration.ConfigurationManager.AppSettings.Get("Password");

            using (var ftpClient = new FtpClient())
            {
                string write = "Write";
                string folderName = $"{channelName}/DIK-v1-0/{write}/{i}.xml";

                ftpClient.ValidateCertificate += new FtpSslValidation(myCertificateValidation);

                ftpClient.Host = ftpAdress;
                ftpClient.EncryptionMode = FtpEncryptionMode.Explicit;
                ftpClient.Port = Convert.ToInt32(port, CultureInfo.InvariantCulture);
                ftpClient.Credentials = new NetworkCredential(userName, password);
                ftpClient.EnableThreadSafeDataConnections = true;
                ftpClient.SslProtocols = System.Security.Authentication.SslProtocols.None;

                // do not open a new connection for each file
                ftpClient.DataConnectionType = FtpDataConnectionType.EPSV;
                ftpClient.SocketKeepAlive = true;
                System.Net.ServicePointManager.Expect100Continue = false;

                ftpClient.Connect();

                using (var fileStream = File.OpenRead(fileInfo.FullName))
                {
                    using (var ftpStream = ftpClient.OpenWrite(folderName, FtpDataType.ASCII))
                    {
                        var buffer = new byte[8 * 1024];
                        int count;
                        while ((count = fileStream.Read(buffer, 0, buffer.Length)) > 0)
                        {
                            ftpStream.Write(buffer, 0, count);
                        }
                    }
                }

                ftpClient.Disconnect();
            }
        }

        private static void myCertificateValidation(FtpClient control, FtpSslValidationEventArgs e)
        {
            e.Accept = true;
        }
    }
}