﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//    Copyright © ABC SOFTWARE. All rights reserved.
//    The source code or its parts to use, reproduce, transfer, copy or
//    keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.SelectAndCreateChannel
{
    using System;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using ProxyToService;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            using (ProxyToService.DitConfiguration.DITConfigurationServiceContractClient client = new ProxyToService.DitConfiguration.DITConfigurationServiceContractClient("ConfigurationService"))
            {
                try
                {
                    string urn = "URN:IVIS:100001:CHA-SampleChannel-v1-0-TYPE-DIK";
                    client.InsertSubChannelVersion(false, ProxyToService.DitConfiguration.ChannelVersionStatusType.testing, 1, 1, urn, false, "URN:IVIS:100001:xslt-100000-FullNameDitTransform-0.0");

                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }
    }
}