<?php
/** 
 * soap-wst.php 
 * 
 * Copyright (c) 2010, ABC Software SIA <abcsoftware@abcsoftware.lv>. 
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 *   * Redistributions of source code must retain the above copyright 
 *     notice, this list of conditions and the following disclaimer. 
 * 
 *   * Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the 
 *     distribution. 
 * 
 *   * Neither the name of Sergejs Degtjars nor the names of his 
 *     contributors may be used to endorse or promote products derived 
 *     from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE. 
 * 
 * @author     Sergejs Degtjars <sergejs.degtjars@abcsoftware.lv> 
 * @copyright  2010 ABC Software SIA <abcsoftware@abcsoftware.lv> 
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License 
 * @version    0.2.0  alpha
 */
 require_once('wsse/xmlseclibs.php');
 class WSTSoap {
     private $namespaces = array(
        'wst' => 'http://schemas.xmlsoap.org/ws/2005/02/trust',
		'wst13' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
        'wsp' => 'http://schemas.xmlsoap.org/ws/2004/09/policy',
        'wsa_subm' => 'http://schemas.xmlsoap.org/ws/2004/08/addressing',
        'wsa_1_0' => 'http://www.w3.org/2005/08/addressing',
        'wsu' => 'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd',
        'soap' => 'http://schemas.xmlsoap.org/soap/envelope/',
        'saml' => 'urn:oasis:names:tc:SAML:1.0:assertion',
        'wsse' => 'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd',
        'xenc' => 'http://www.w3.org/2001/04/xmlenc#',
        'ds' => 'http://www.w3.org/2000/09/xmldsig#'
        ); 
     
     private $payload;
     private $rstnode;
     private $tokenType;
     private $requestType;
     private $appliesTo;
     private $entropy;
     private $TTL;
     private $claims;
	 private $keytype;
	 private $wstns;

     public function __construct($requestType, $wstver='2005') {
         if ($wstver == '13') { $this->wstns = $this->namespaces['wst13']; } else { $this->wstns = $this->namespaces['wst'];}
         $this->requestType = $requestType;
         $payload = new DOMDocument();
         $rst = $payload->createElementNS($this->wstns,'wst:RequestSecurityToken');
         $rst = $payload->appendChild($rst);
         $this->payload = $payload;
         $this->rstnode = $rst;
         unset($payload);
         unset($rst);
     }
     
     public function setTokenType($tokenType) {
         $this->tokenType = $tokenType;
     }
     
     public function setDestination($appliesTo) {
         $this->appliesTo = $appliesTo;
     }
     
     public function setTTL($ttl=14400) {
         $this->TTL = $ttl;
     }
     
     public function genEntropy() {
        $objKey = new XMLSecurityKey(XMLSecurityKey::AES256_CBC); 
        $this->entropy = base64_encode($objKey->generateSessionKey()); 
        unset($objKey);
     }
     
     public function requestClaims($claims) {
         $this->claims = $claims;
     }
     public function setKeyType($keytype) {
         $this->keytype = $keytype;
     }
     public function saveXML($soapVersion) {
         if (!is_null($this->tokenType)) {
             $tokenType = $this->payload->createElementNS($this->wstns, 'wst:TokenType', $this->tokenType);
             $this->rstnode->appendChild($tokenType);
         }
         
         $requestType = $this->payload->createElementNS($this->wstns, 'wst:RequestType', $this->requestType);
         $this->rstnode->appendChild($requestType);
         
         if (!is_null($this->appliesTo)) {
             $to = $this->payload->createElementNS($this->namespaces['wsp'], 'wsp:AppliesTo');
             $this->rstnode->appendChild($to);
             switch ($soapVersion) {
                 case SOAP_1_2:
                     $endpoint= $this->payload->createElementNS($this->namespaces['wsa_1_0'], 'wsa:EndpointReference');
                     $address = $this->payload->createElementNS($this->namespaces['wsa_1_0'], 'wsa:Address',$this->appliesTo);
                     break;
                 default:
                     $endpoint= $this->payload->createElementNS($this->namespaces['wsa_subm'], 'wsa:EndpointReference');
                     $address = $this->payload->createElementNS($this->namespaces['wsa_subm'], 'wsa:Address',$this->appliesTo);
                     break;
             }
             $to->appendChild($endpoint);
             $endpoint -> appendChild($address);
         }
         
         if (!is_null($this->keytype)) {
             $keytype = $this->payload->createElementNS($this->wstns, 'wst:KeyType', $this->keytype);
             $this->rstnode->appendChild($keytype);
         }
         if (!is_null($this->claims)) {
             $claims = $this->payload->createElementNS($this->wstns, 'wst:Claims');
             $claimsnode = $this->rstnode->appendChild($claims);
             $claimsnode -> setAttribute('xmlns:i', 'http://schemas.xmlsoap.org/ws/2005/05/identity');
             $claimsnode -> setAttribute('Dialect', 'http://schemas.xmlsoap.org/ws/2005/05/identity');
             foreach ($this->claims as $k => $v) {
                 $claim = $claimsnode->appendChild($this->payload->createElementNS('http://schemas.xmlsoap.org/ws/2005/05/identity', 'i:ClaimType'));
                 $claim -> setAttribute('Uri', $v['uri']);
                 if(array_key_exists('optional', $v)) {
					$claim -> setAttribute('Optional', $v['optional'] ? 'true' : 'false');
				 }
             }
         }
         
         if(!is_null($this->entropy)) {
             $entropy = $this->payload->createElementNS($this->wstns, 'wst:Entropy');
             $this->rstnode->appendChild($entropy);
             $binarysecret = $this->payload->createElementNS($this->wstns, 'wst:BinarySecret', $this->entropy);
             $entropy->appendChild($binarysecret);
             $binarysecret->setAttribute('Type','http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey');
         }
         if (!is_null($this->TTL)) {
             $currentTime = time();
             $lifetime = $this->payload->createElementNS($this->wstns, 'wst:Lifetime');
             $this->rstnode->appendChild($lifetime);
             $expires = $this->payload->createElementNS($this->namespaces['wsu'],'wsu:Expires',gmdate("Y-m-d\TH:i:s", $currentTime + $this->TTL).'Z');
             $lifetime->appendChild($expires);
         }
         $this->payload->normalizeDocument();
         return $this->payload->saveXML($this->rstnode);
     }
     
	 
	 public function rawTokenFromResponse($response) {
		$start = '<saml:Assertion';
		$end = '</saml:Assertion>';
		return substr($response, strpos($response, $start), strpos($response, $end) - strpos($response, $start) + strlen($end));
	 }
	 
     public function processResponse($soap_response) {
		 
		 $tokens = array();
         $response = new DOMDocument();
         $response->loadXML($soap_response);
		 $retToken = '';
		 
         $xpath = new DOMXPath($response);
         $xpath->registerNamespace('wst', $this->wstns);
         $rstr_list = $xpath->query('//wst:RequestSecurityTokenResponse');
         if ($rstr_list->length == 0) throw new Exception('No tokens returned');
         foreach ($rstr_list as $rstr) {
             $rstr_dom = new DOMDocument();
             $rstr_node = $rstr_dom->importNode($rstr,true);
             $rstr_dom->appendChild($rstr_node);
             // Get clear token from response
             $rxpath = new DOMXPath($rstr_dom);
             $rxpath->registerNamespace('wst', $this->wstns);
             //$rxpath->registerNamespace('wsu', $this->namespaces['wsu']);
             //$rxpath->registerNamespace('default1', $this->namespaces['ds']);
             //$rxpath -> registerNamespace('wsse', $this->namespaces['wsse']);
             $token = $rxpath->query('/wst:RequestSecurityTokenResponse/wst:RequestedSecurityToken',$rstr_dom,true)->item(0)->firstChild;
			if ($token->localName == 'Assertion')
			{
				 $retToken = $this->rawTokenFromResponse($response->saveXML());
			}
			else
			{
				$tdom = new DOMDocument();
				$tdom_node = $tdom->importNode($token,true);
				$tdom->appendChild($tdom_node);
				$retToken = $tdom->saveXML($tdom_node);
			}
			
             // Get token lifetime
             $lifetime['Created'] = $rxpath->evaluate('/wst:RequestSecurityTokenResponse/wst:Lifetime/wsu:Created[1]/text()')->item(0)->wholeText;
             $lifetime['Expires'] = $rxpath->evaluate('/wst:RequestSecurityTokenResponse/wst:Lifetime/wsu:Expires[1]/text()')->item(0)->wholeText;
             // Get key references
             $ARQuery = '/wst:RequestSecurityTokenResponse/wst:RequestedAttachedReference';
             $ARKeyId = $rxpath->query($ARQuery)->item(0)->firstChild;
             $URQuery = '/wst:RequestSecurityTokenResponse/wst:RequestedUnattachedReference';
             $URKeyId = $rxpath->query($URQuery)->item(0)->firstChild;
             // Get key
             $EncriptedKeyQuery = '/wst:RequestSecurityTokenResponse/wst:RequestedProofToken/wst:BinarySecret[1]/text()';
             $Key = $rxpath->query($EncriptedKeyQuery)->item(0); //->wholeText;
             if ($Key == '') {
                 $EntropyQuery = '/wst:RequestSecurityTokenResponse/wst:Entropy/wst:BinarySecret[1]/text()';
                 $RetEntropytmp = $rxpath->evaluate($EntropyQuery);
				if ($RetEntropytmp->length > 0) {
                 $RetEntropy = $rxpath->evaluate($EntropyQuery)->item(0)->wholeText;
                 $KeySizeQuery = '/wst:RequestSecurityTokenResponse/wst:KeySize[1]/text()';
                 $KeySize = $rxpath->evaluate($KeySizeQuery)->item(0)->wholeText;
                 $KeySize = intval($KeySize) >> 3;
					 $Key = $this->PSHA1($this->entropy, $RetEntropy, 0, $KeySize);}
             } else {
                 $Key = $Key->wholeText;
             }
             
			 
			 // $tokenRawXml = $this->rawTokenFromResponse($response->saveXML());
			 
             $tokens[] = array('token' => $retToken ,
                                'arkeyid' => $ARKeyId,
                                'urkeyid' => $URKeyId,
                                'key' => $Key,
                                'lifetime' => $lifetime);
         }
         return $tokens;
     }
     
     private function PSHA1($secret, $seed, $offset, $length) {
        $be1 = base64_decode($secret);
        $be2 = base64_decode($seed);
        $ai = $be2;
        $key = '';
        do {
            $ai = hash_hmac("sha1",$ai,$be1,true);
            $key = $key . hash_hmac("sha1", $ai . $be2, $be1, true);
        } while (strlen($key)< ($offset + $length));
        $key = base64_encode(substr($key, $offset, $length));
        return $key;
    }
 }
?>
