<?php
/* 
	Author Maksims Markovs | ABC software 
	maksims.markovs@abcsoftware.lv
	
	singletone class for capturing sts and service call raw xml data
	and exporting this data in json format (for viewer.html as a client)
*/

class Milestone
{
	private $milestones = array();
    private static $Instance;

    private function __construct() 
    { 
    }

    public static function getInstance()
    {
        if (!self::$Instance)
        {
            self::$Instance = new Milestone();
        }

        return self::$Instance;
    }

    public function addSTSCallmilestone($sts_service, $sts_addr)
    {
		 $this->milestones['sts_request'] = $sts_service->__getLastRequest();
         $this->milestones['sts_response'] = $sts_service->__getLastResponse();
		 $this->milestones['sts_service'] = $sts_addr;
		 return $this;
    }

    public function addServiceCallMilestone($service, $service_addr, $method_name)
    {
		$this->milestones['service_calls'][] = array('service' => $service_addr, 
											'method' => $method_name, 
											'data' => $service->__getLastRequest(),
											'type' => 'request');
											
		$this->milestones['service_calls'][] = array('service' => $service_addr, 
											'method' => $method_name,
											'type' => 'response',
											'data' => $service->__getLastResponse());				
		return $this;
    }
	
	public function fromatXML() {
		foreach ($this->milestones as $key => $value) {
			if($key == 'service_calls') {
				foreach ($this->milestones['service_calls'] as $key1 => $value1) {
					$dom = new DOMDocument;
					$dom->preserveWhiteSpace = false;
					$dom->loadXML($this->milestones['service_calls'][$key1]['data']); 
					$dom->formatOutput = true;
					$this->milestones['service_calls'][$key1]['data'] = $dom->saveXml();
				}
			} else {
				if($key == 'sts_request' || $key == 'sts_response')
				{
					$dom = new DOMDocument;
					$dom->preserveWhiteSpace = false;
					$dom->loadXML($this->milestones[$key]); 
					$dom->formatOutput = true;
					$this->milestones[$key] = $dom->saveXml();
				}
			}
		}
	}
	
	public function getJSON() {
		return json_encode($this->milestones);
	}

}


?>