<?php
header("Content-Type: application/json; charset=UTF-8");

require_once('lib/milestone.php'); 
require_once('client.my.php');

require_once('config.php');

$sts = new STSClient(NULL, array(
							'trace' => 1,
							'location' => $sts_address.'/trust/13/certificatemixed',
                            'uri' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
                            'exceptions' => TRUE,
                            'style'    => SOAP_DOCUMENT,
                            'use'      => SOAP_LITERAL,
                            'soap_version' => SOAP_1_2
                            ));

$service = new mySOAP($DIT_config_service_addr.'?wsdl', array(
										 'exceptions' => TRUE,
                                         'soap_version' => SOAP_1_2,
                                         'location' => $DIT_config_service_addr.'/ws2007FederationNoSct',
                                         'trace' => 1));
										 
$ms = Milestone::getInstance();
										
try {                                         
try {	
	$claims[] = array('uri' => "http://www.oasis-open.org/RSA2004/attributes/AUTHORITY");
	$claims[] = array('uri' => "http://docs.oasis-open.org/wsfed/authorization/200706/claims/action");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/sid");
	$claims[] = array('uri' => "http://ivis.eps.gov.lv/schema/identity/claims/employeegroup");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name");
	$claims[] = array('uri' => "urn:ivis:100001:name.id-viss");
	
	$cert = file_get_contents('cert/public.pem');
	$private_key = file_get_contents('cert/not_enc.pem');
	
    $tokens = $sts->issueTokenCert($cert, $private_key, $apply_to, $claims);


    //$tokens = $sts->issueToken($username, $password, $apply_to, $claims);
      	  
	$ms->addSTSCallmilestone($sts, $sts_address);
		
    // set Token for service call - we use only first token from collection if many returned
    $service->customtoken = $tokens[0];

	$channel_name = 'SampleChannel2';
	$channel_urn = 'URN:IVIS:100001:CHA-'.$channel_name.'-TYPE-DIK';
	$minor_v = 0; //version minor value
	$major_v = 1; //version major value
	$channel_version_URN = 'URN:IVIS:100001:CHA-'  .$channel_name. '-v' . $major_v . "-" . $minor_v . '-TYPE-DIK';
	
	
	$req =  array( 
		'ChannelSearch'        => array(
			'OnlyHeader' => true,
			'Channel' =>  array(
				'ChannelURN' => $channel_urn
			)
		),
		'ChannelVersionStatus' => array('creating', 'testing', 'active', 'tehnicalbreak', 'activedepricated', 'deleted')
	); 
	
	$method_name = 'SearchChannelsPaged';								
	$result = $service->__soapCall($method_name, array($req) );
	$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);
	
	// setting channel data
	$channel = array(
		'ShortName' => $channel_name,
		'ChannelURN' => $channel_urn,
		'ChannelType' => 'dik',
		'OwnerAuthority' => array(
			'AuthorityID' => '100000',
			'ShortName' => 'ABC software',
		),
		'ChannelName' => $channel_name
	);
	
	//if channel not found creating new one
	if($result->ChannelList->Count == 0) {
		// adding channel data to request
		$req2 =  array( 
			'Channel' => $channel
		);
	
		$method2_name = 'InsertChannel';								
		$result2 = $service->__soapCall($method2_name, array($req2) );
		$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method2_name);
		
		$result2->InsertChannelResponse;
	} else {
		//channel found
	}
	
	
	$channel_version = array(
		'MessageType' => array(
			0 =>  array(
				'MessageClass' => array(
					'CodeListCodeValue' => '1'),
				'XMLSchemaURN' => 'URN:IVIS:100001:XSD-Person-FullName-v1-0-TYPE-PersonFullName'
			),
			1 =>  array(
				'MessageClass' => array(
					'CodeListCodeValue' => '3'),
				'XMLSchemaURN' => 'URN:IVIS:100001:XSD-DIT-DITMessage-v1-0-TYPE-DefaultMessageError',
			)
		),
		'ChannelVersionStatus' => 'active',
		'Channel' => $channel,
		'MinorVersion' => $minor_v,
		'MajorVersion' => $major_v,
		'ChannelVersionURN' => $channel_version_URN
	);
	
	$req3 =  array( 
		'ChannelVersionSearch' => array(
		'ChannelVersion' => $channel_version
		)
	); 
	
	$method_name = 'SearchChannelVersionsPaged';								
	$result = $service->__soapCall($method_name, array($req3) );
	$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);

	//if channel version not found creating new one
	if($result->ChannelVersionsList->Count == 0) {
		// adding channel version data to request
		$req =  array( 
			'ChannelVersionData' => $channel_version
		);
	
		$method_name = 'InsertChannelVersion';								
		$result = $service->__soapCall($method_name, array($req) );
		$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);
		
	} else {
		//channel version found

	}
	
	$channel_subscriber = array(
		'ChannelSubscriber' => array(
			'ChannelVersionURN' => $channel_version_URN,
			'SubscriberAuthority' => array(
				'AuthorityID' => '100001',
				'ShortName' => 'ABC software'
			)
		)
	);
	
	$req = array(
		'ChannelSubscriberSearch' => $channel_subscriber
	);
	
	$method_name = 'SearchSubscribersToChannelPaged';								
	$result = $service->__soapCall($method_name, array($req));
	$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);
	
	//if subscrition to the channel version not found creating new one
	if($result->ChannelSubscriberList->Count == 0) {
		$method_name = 'InsertSubscriberToChannel';								
		$result = $service->__soapCall($method_name, array($channel_subscriber));
		$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);
	} else {
		//subscrition to the channel version found
	}
	
	
	$ms->fromatXML();
	echo $ms->getJSON();
    
} catch (SoapFault $fault) {
    //var_dump($fault);
	echo $fault;
}
} catch (Exception $ex)  {
    //echo $ex->getMessage();
	var_dump($ex);
}





?>