<?php
header("Content-Type: application/json; charset=UTF-8");

require_once('lib/milestone.php'); 
require_once('client.my.php');
require_once('config.php');

$sts = new STSClient(NULL, array(
							'trace' => 1,
							'location' => $sts_address.'/trust/13/certificatemixed',
                            'uri' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
                            'exceptions' => TRUE,
                            'style'    => SOAP_DOCUMENT,
                            'use'      => SOAP_LITERAL,
                            'soap_version' => SOAP_1_2
                            ));




$service = new mySOAP($DIT_config_service_addr.'?wsdl', array(
										 'exceptions' => TRUE,
                                         'soap_version' => SOAP_1_2,
                                         'location' => $DIT_config_service_addr.'/ws2007FederationNoSct',
                                         'trace' => 1));
										 
$ms = Milestone::getInstance();
										
try {                                         
try {	
	$claims[] = array('uri' => "http://www.oasis-open.org/RSA2004/attributes/AUTHORITY");
	$claims[] = array('uri' => "http://docs.oasis-open.org/wsfed/authorization/200706/claims/action");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/sid");
	$claims[] = array('uri' => "http://ivis.eps.gov.lv/schema/identity/claims/employeegroup");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name");
	$claims[] = array('uri' => "urn:ivis:100001:name.id-viss");
	
	$cert = file_get_contents('cert/public.pem');
	$private_key = file_get_contents('cert/not_enc.pem');
    
	$tokens = $sts->issueTokenCert($cert, $private_key, $apply_to, $claims);
      	  
	$ms->addSTSCallmilestone($sts, $sts_address);
		
    // set Token for service call - we use only first token from collection if many returned
    $service->customtoken = $tokens[0];

	$channel_name = 'SampleChannel';
	$channel_urn = 'URN:IVIS:100001:CHA-'.$channel_name.'-TYPE-DIK';
	$req =  array( 
		"ChannelSearch"  => array(
			"OnlyHeader" => true,
			"Channel" =>  array(
				"ChannelURN" => $channel_urn
			)
		),
		'ChannelVersionStatus' => array('creating', 'testing', 'active', 'tehnicalbreak', 'activedepricated', 'deleted')
	); 
	
	$method_name = 'SearchChannelsPaged';								
	$result = $service->__soapCall($method_name, array($req) );
	$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);
	
	//if channel not found creating new one
	if($result->ChannelList->Count == 0) {
	    $req2 =  array( 
			'Channel' => array(
				'ShortName' => $channel_name,
				'ChannelURN' => $channel_urn,
				'ChannelType' => 'dik',
				'OwnerAuthority' => array(
					'AuthorityID' => '100000',
					'ShortName' => 'test',
				),
				'ChannelName' => $channel_name
			)
		);
	    		
		$method2_name = 'InsertChannel';								
		$result2 = $service->__soapCall($method2_name, array($req2) );
		$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method2_name);

	} else {
		// channel found...
	}

	$ms->fromatXML();
	echo $ms->getJSON();
    
} catch (SoapFault $fault) {
	echo $fault;
}
} catch (Exception $ex)  {
    echo $ex->getMessage();
}
?>