<?php
header("Content-Type: application/json; charset=UTF-8");

require_once('lib/milestone.php'); 
require_once('client.my.php');

require_once('config.php');

$sts = new STSClient(NULL, array(
							'trace' => 1,
							'location' => $sts_address.'/trust/13/certificatemixed',
                            'uri' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
                            'exceptions' => TRUE,
                            'style'    => SOAP_DOCUMENT,
                            'use'      => SOAP_LITERAL,
                            'soap_version' => SOAP_1_2
							));
							
$sts2 = new STSClient(NULL, array(
								'trace' => 1,
								'location' => $sts_address.'/trust/13/usernamemixed',
								'uri' => 'http://docs.oasis-open.org/ws-sx/ws-trust/200512',
								'exceptions' => TRUE,
								'style'    => SOAP_DOCUMENT,
								'use'      => SOAP_LITERAL,
								'soap_version' => SOAP_1_2
								));

$service = new mySOAP($DIT_config_service_addr.'?wsdl', array(
							'exceptions' => TRUE,
                            'soap_version' => SOAP_1_2,
                            'location' => $DIT_config_service_addr.'/ws2007FederationNoSct',
                            'trace' => 1));
										 
$service2 = new mySOAP($DIT_WCF_service_addr.'?wsdl', array(
							'exceptions' => TRUE,
                            'soap_version' => SOAP_1_2,
                            'location' => $DIT_WCF_service_addr.'/ws2007FederationNoSct',
							'trace' => 1));
							
$service3 = new mySOAP($DIT_WCF_service_addr.'?wsdl', array(
								'exceptions' => TRUE,
								'soap_version' => SOAP_1_2,
								'location' => $DIT_WCF_service_addr.'/ws2007FederationNoSct',
								'trace' => 1));
										 
$ms = Milestone::getInstance();
										
try {                                         
try {
	$claims[] = array('uri' => "http://www.oasis-open.org/RSA2004/attributes/AUTHORITY");
	$claims[] = array('uri' => "http://docs.oasis-open.org/wsfed/authorization/200706/claims/action");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/sid");
	$claims[] = array('uri' => "http://ivis.eps.gov.lv/schema/identity/claims/employeegroup");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
	$claims[] = array('uri' => "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name");
	$claims[] = array('uri' => "urn:ivis:100001:name.id-viss");
	
    $cert = file_get_contents('cert/public.pem');
	$private_key = file_get_contents('cert/not_enc.pem');
	
    $tokens = $sts->issueTokenCert($cert, $private_key, $apply_to, $claims);
      	  
	$ms->addSTSCallmilestone($sts, $sts_address);
		
    // set Token for service call - we use only first token from collection if many returned
    $service->customtoken = $tokens[0];
	$service2->customtoken = $tokens[0];

	// set UsernameToken variables and request for tokens
	$username = 'usernamevraa';
	$password = 'AaVa!}x5d5_iLk';
	 
	$tokens = $sts2->issueToken($username, $password, $apply_to, $claims);
			 
	$ms->addSTSCallmilestone($sts2, $sts_address);
		 
	$service3->customtoken = $tokens[0];

	
	$channel_name = 'SampleChannel579';
	$channel_urn = 'URN:IVIS:100001:CHA-'.$channel_name.'-TYPE-DIK';
	$minor_v = 0; //version minor value
	$major_v = 1; //version major value
	$channel_version_URN = 'URN:IVIS:100001:CHA-'  .$channel_name. '-v' . $major_v . "-" . $minor_v . '-TYPE-DIK';
	
	
	$req =  array( 
		'ChannelSearch'        => array(
			'OnlyHeader' => true,
			'Channel' =>  array(
				'ChannelURN' => $channel_urn
			)
		),
		'ChannelVersionStatus' => array('creating', 'testing', 'active', 'tehnicalbreak', 'activedepricated', 'deleted')
	); 
	
	$method_name = 'SearchChannelsPaged';								
	$result = $service->__soapCall($method_name, array($req) );
	$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);
	
	// setting channel data
	$channel = array(
		'ShortName' => $channel_name,
		'ChannelURN' => $channel_urn,
		'ChannelType' => 'dik',
		'OwnerAuthority' => array(
			'AuthorityID' => '100000',
			'ShortName' => 'ABC software',
		),
		'ChannelName' => $channel_name
	);
	
	//if channel not found creating new one
	if($result->ChannelList->Count == 0) {
		// adding channel data to request
		$req2 =  array( 
			'Channel' => $channel
		);
	
		$method2_name = 'InsertChannel';								
		$result2 = $service->__soapCall($method2_name, array($req2) );
		$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method2_name);
		
		$result2->InsertChannelResponse;
	} else {
		//channel found
	}
	
	$channel_version = array(
		'MessageType' => array(
			0 =>  array(
				'MessageClass' => array(
					'CodeListCodeValue' => '1'),
				'XMLSchemaURN' => 'URN:IVIS:100001:XSD-Person-FullName-v1-0-TYPE-PersonFullName'
			),
			1 =>  array(
				'MessageClass' => array(
					'CodeListCodeValue' => '3'),
				'XMLSchemaURN' => 'URN:IVIS:100001:XSD-DIT-DITMessage-v1-0-TYPE-DefaultMessageError',
			)
		),
		'ChannelVersionStatus' => 'active',
		'Channel' => $channel,
		'MinorVersion' => $minor_v,
		'MajorVersion' => $major_v,
		'ChannelVersionURN' => $channel_version_URN
	);
	
	$req3 =  array( 
		'ChannelVersionSearch' => array(
			'ChannelVersion' => $channel_version
		)
	); 
	
	$method_name = 'SearchChannelVersionsPaged';								
	$result = $service->__soapCall($method_name, array($req3) );
	$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);

	//if channel version not found creating new one
	if($result->ChannelVersionsList->Count == 0) {
		// adding channel version data to request
		$req =  array( 
			'ChannelVersionData' => $channel_version
		);
	
		$method_name = 'InsertChannelVersion';								
		$result = $service->__soapCall($method_name, array($req) );
		$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);
		
	} else {
		//channel version found
	}

	$req = array( 
		'ChannelSubscriberSearch' => array(
			'ChannelSubscriber' => array(
				'ChannelVersionURN' => $channel_version_URN,
				'SubscriberAuthority' => array(
					'AuthorityID' => '100001',
					'ShortName' => 'VRAA',
					'Name' => 'VRAA'
				)
			)
		)
	);

	$method_name = 'SearchSubscribersToChannelPaged';								
	$result = $service->__soapCall($method_name, array($req) );
	$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);

	if($result->ChannelSubscriberList->Count == 0) {
		// Channel subscriber created
		$req = array( 
			'ChannelSubscriber' => array(
				'ChannelVersionURN' => $channel_version_URN,
				'SubscriberAuthority' => array(
					'AuthorityID' => '100001',
					'ShortName' => 'VRAA',
					'Name' => 'VRAA'
				)
			)
		);
	
		$method_name = 'InsertSubscriberToChannel';								
		$result = $service->__soapCall($method_name, array($req) );
		$ms->addServiceCallMilestone($service, $DIT_config_service_addr, $method_name);
		
	} else {
		// Channel subscriber found
	}
	
    $dom = new DOMDocument('1.0', 'UTF-8');
	$dom->loadXML(file_get_contents('xml/data.xml')); 

	$req =  array( 
		'MessageSave2' => array(
			'ReceiverFilter' => array(
				'Authority' => array('100001')
			),
			'ChannelVersionURN' => $channel_version_URN,			
			'BussinesMessage' => array(
				'any' => array(
					$dom->saveXML($dom->documentElement)
				)
			)
		)
	);

	$method_name = 'SendMessage2';
	$result2 = $service2->__soapCall($method_name, array($req));
	$ms->addServiceCallMilestone($service2, $DIT_WCF_service_addr, $method_name);

	$req = array(
		'MessageRequest' => array(
			'ChannelVersionURN' => $channel_version_URN
		)
   );
	
   $method_name = 'ReceiveMessage2';								
   $result = $service3->__soapCall($method_name, array($req));
   $ms->addServiceCallMilestone($service3, $DIT_WCF_service_addr, $method_name);

   $messageId = $result->MessageResponse2->Items[0]->MessageID;

   $req = array(
	'MessageSampleId' => $messageId
	);

	$method_name = 'ConfirmationAck';
	$result = $service3->__soapCall($method_name, array($req));
	$ms->addServiceCallMilestone($service3, $DIT_WCF_service_addr, $method_name);
		
	
	$ms->fromatXML();
	echo $ms->getJSON();
    
} catch (SoapFault $fault) {
	echo $fault;
}
} catch (Exception $ex)  {
	var_dump($ex);
}

?>