/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package lv.abcsoftware.eves.samples.restoremessages;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.BindingProvider;
import lv.gov.eps.ivis.iss.ditservice.v1_0.DeleteMessage;
import lv.gov.eps.ivis.iss.ditservice.v1_0.IDITMessageServiceContract;
import lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessageList;
import lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessageListResponse;
import lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessageResponse;
import lv.gov.eps.ivis.iss.ditservice.v1_0.RestoreMessageList;
import lv.gov.eps.ivis.iss.ditservice.v1_0.SendMessage;
import lv.gov.eps.ivis.iss.ditservice.v1_0.DITMessageService;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.BussinesMessageType;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageListRequestStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageRequestStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageSaveStructure2;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageType;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RestoreMessages {

    public static void main(String[] args) {
        String channelName = "SampleChannel7";
        String channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
        String channelVersionURN = "URN:IVIS:100001:CHA-" + channelName + "-v1-0-TYPE-DIK";

        SpringBusFactory bf = new SpringBusFactory();
        BusFactory.setDefaultBus(bf.createBus("../ProxyToService/src/main/resources/client-username.xml"));

        DITMessageService dITService = new DITMessageService();

        IDITMessageServiceContract ditClient = dITService.getWs2007FederationNoSct();
        Map<String, Object> ditCtx = ((BindingProvider) ditClient).getRequestContext();
        ditCtx.put("ws-security.username", "DitAdmin");
        ditCtx.put("ws-security.password", "password");


        MessageSaveStructure2 message = new MessageSaveStructure2();
        message.setChannelVersionURN(channelVersionURN);
        BussinesMessageType bussinesMessage = new BussinesMessageType();
        message.setBussinesMessage(bussinesMessage);

        Object obj = getObject();
        bussinesMessage.setAny(obj);

        SendMessage sendMessage = new SendMessage();
        sendMessage.setMessageSave2(message);

        lv.gov.eps.ivis.iss.ditservice.v1_0.SendMessageResponse sendMessageResponse1 = ditClient.sendMessage2(sendMessage);
        System.out.println("Message Sent : " + sendMessageResponse1.isSendMessageResult());

        ((BindingProvider) ditClient).getRequestContext().put("ws-security.username", "username3");
        ((BindingProvider) ditClient).getRequestContext().put("ws-security.password", "_%qTpgPA9Z_qMJ");

        MessageRequestStructure messageRequest = new MessageRequestStructure();
        messageRequest.setChannelURN(channelURN);

        lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessage request = new lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessage();
        request.setMessageRequest(messageRequest);

        ReceiveMessageResponse response = ditClient.receiveMessage2(request);
        System.out.println("Message received: " + response.getMessageResponse2().getBussinesMessageOrEventMessageTypeOrMessage());

        MessageListRequestStructure messageListRequest = new MessageListRequestStructure();
        messageListRequest.setChannelVersionURN(channelVersionURN);
        messageListRequest.setReadMessage(true);

        ReceiveMessageList receiveMessageList = new ReceiveMessageList();
        receiveMessageList.setMessageListRequest(messageListRequest);

        ReceiveMessageListResponse receiveMessageListResponse = ditClient.receiveMessageList(receiveMessageList);
        System.out.println("ReceiveMessageList");

        if (receiveMessageListResponse.getMessageBasicInfoList() != null) {           
            RestoreMessageList restoreMessageList = new RestoreMessageList();
            restoreMessageList.setMessageBasicInfoList(receiveMessageListResponse.getMessageBasicInfoList());
            ditClient.restoreMessageList(restoreMessageList);
        }
        
        response = ditClient.receiveMessage2(request);

        if (response != null && !response.getMessageResponse2().getBussinesMessageOrEventMessageTypeOrMessage().isEmpty()) {
            for (MessageType mt : response.getMessageResponse2().getBussinesMessageOrEventMessageTypeOrMessage()) {
                System.out.println("message receved id: " + mt.getMessageID());
                MessageRequestStructure messageRequestDelete = new MessageRequestStructure();
                messageRequestDelete.setMessageID(mt.getMessageID());
                DeleteMessage deleteMessageRequest = new DeleteMessage();
                deleteMessageRequest.setMessageRequest(messageRequest);
                ditClient.deleteMessage(deleteMessageRequest);
                System.out.println("message deleted id:" + mt.getMessageID());
            }
        }
    }

    static Object getObject() {
        try {
            File fXmlFile = new File("../data.xml");

            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();

            Element e = doc.getDocumentElement();
            return e;

        } catch (SAXException ex) {
            Logger.getLogger(RestoreMessages.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(RestoreMessages.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(RestoreMessages.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}
