/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package lv.abcsoftware.eves.samples.receivemessage;

import java.util.Map;
import javax.xml.ws.BindingProvider;
import lv.gov.eps.ivis.iss.ditservice.v1_0.DeleteMessage;
import lv.gov.eps.ivis.iss.ditservice.v1_0.IDITMessageServiceContract;
import lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessageResponse;
import lv.gov.eps.ivis.iss.ditservice.v1_0.DITMessageService;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageRequestStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.MessageType;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;

public class ReceiveMessage {

    public static void main(String[] args) {
        SpringBusFactory bf = new SpringBusFactory();
        BusFactory.setDefaultBus(bf.createBus("ProxyToService/src/main/resources/client-cert.xml"));

        String channelName = "SampleChannel";
        String channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
        String channelVersionURN = "URN:IVIS:100001:CHA-" + channelName + "-v1-0-TYPE-DIK";

        DITMessageService dITService = new DITMessageService();

        IDITMessageServiceContract ditClient = dITService.getWs2007FederationNoSct();
        Map<String, Object> ditCtx = ((BindingProvider) ditClient).getRequestContext();
        /*ditCtx.put("ws-security.username", "username3");
        ditCtx.put("ws-security.password", "_%qTpgPA9Z_qMJ");*/

        MessageRequestStructure messageRequest = new MessageRequestStructure();
        messageRequest.setChannelURN(channelURN);
        messageRequest.setChannelVersionURN(channelVersionURN);

        lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessage request = new lv.gov.eps.ivis.iss.ditservice.v1_0.ReceiveMessage();
        request.setMessageRequest(messageRequest);

        ReceiveMessageResponse response = ditClient.receiveMessage2(request);
        System.out.println("Message received: " + response.getMessageResponse2().getBussinesMessageOrEventMessageTypeOrMessage());

        if (response != null && !response.getMessageResponse2().getBussinesMessageOrEventMessageTypeOrMessage().isEmpty()) {
            for (MessageType mt : response.getMessageResponse2().getBussinesMessageOrEventMessageTypeOrMessage()) {
                System.out.println("message receved id: " + mt.getMessageID());
                MessageRequestStructure messageRequestDelete = new MessageRequestStructure();
                messageRequestDelete.setMessageID(mt.getMessageID());
                DeleteMessage deleteMessageRequest = new DeleteMessage();
                deleteMessageRequest.setMessageRequest(messageRequest);
                ditClient.deleteMessage(deleteMessageRequest);
                System.out.println("message deleted id:" + mt.getMessageID());
            }
        }
    }
}
