/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package lv.abcsoftware.eves.samples.channel;

import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.DITConfigurationService;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.IDITConfigurationServiceContract;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertChannel;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.InsertChannelResponse;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SearchChannelsPaged;
import lv.gov.eps.ivis.iss.ditconfigurationservice.v1_2.SendMessageResponse;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelSearchInfoStructure;
import lv.gov.eps.ivis.xmlschemas._100000.dit.v1_0.ChannelType;
import lv.gov.eps.ivis.xmlschemas._100001.ivis.v1_0.AuthorityBasicInfoStructure;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;

public class SelectAndCreateChannel {

    public static void main(String[] args) {
        SpringBusFactory bf = new SpringBusFactory();        
        BusFactory.setDefaultBus(bf.createBus("ProxyToService/src/main/resources/client-cert.xml"));

        DITConfigurationService service = new DITConfigurationService();
        IDITConfigurationServiceContract port = service.getWs2007FederationNoSct();

        String channelName = "SampleChannel";
        String channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
        ChannelSearchInfoStructure req = new ChannelSearchInfoStructure();

        req.setChannel(new ChannelInfoStructure());
        req.getChannel().setChannelURN(channelURN);
        req.setOnlyHeader(true);

        SearchChannelsPaged searchChannelsPaged = new SearchChannelsPaged();
        searchChannelsPaged.setChannelSearch(req);
        SendMessageResponse sendMessageResponse = port.searchChannelsPaged(searchChannelsPaged);
               
        if (sendMessageResponse.getChannelList().getCount() == 0) {
            System.out.println("Channel creation..");

            ChannelInfoStructure channel = new ChannelInfoStructure();
            channel.setShortName(channelName);
            channel.setChannelURN(channelURN);
            channel.setChannelType(ChannelType.DIK);
            channel.setOwnerAuthority(new AuthorityBasicInfoStructure());
            channel.getOwnerAuthority().setAuthorityID("100000");
            channel.setChannelName(channelName);
            
            InsertChannel insertChannel = new InsertChannel();
            insertChannel.setChannel(channel);
            InsertChannelResponse insertChannelResponse = port.insertChannel(insertChannel);
            
            int id = insertChannelResponse.getInsertChannelResponse();           

            System.out.println("Channel created " + id);
        } else {
            System.out.println("Channel found");
        }

    }
}
