{{/* vim: set filetype=mustache: */}}


{{/*
Params format helper
*/}}
{{- define "_formatParams" -}}
{{- $params := list -}}
{{- range $key, $val := . -}}
{{ $params = printf "%s=%s" $key $val | append $params }}
{{- end -}}
{{- join "&" $params | printf "%s" -}}
{{- end -}}

{{/*
Parse hosts string
*/}}
{{- define "_parseHosts" -}}
{{- $tmpList := list -}}
{{- range . -}}
{{- $tmpList = .port | toString | printf "%s:%s" .host | append $tmpList -}}
{{- end -}}
{{- $tmpList | join "," -}}
{{- end -}}


{{/*
mongodb connectionString helper
*/}}
{{- define "mongodbConnStr" -}}
{{- $externalSvc := .Values.global.mongodb -}}
{{- $defParams := dict "authSource" "admin" "journal" "true" -}}
{{- if $externalSvc.replicaSet.enabled -}}
{{- $defParams = dict "replicaSet" $externalSvc.replicaSet.name "w" "majority" | mergeOverwrite $defParams -}}
{{- end -}}
{{- $connParams := dict -}}
{{- if .Values.mongodb.connectionParams -}}
{{- $connParams = mergeOverwrite $defParams .Values.mongodb.connectionParams -}}
{{- else -}}
{{- $connParams = $defParams -}}
{{- end -}}
{{- $connParamsStr := include "_formatParams" $connParams -}}
{{- $serverList := include "_parseHosts" $externalSvc.hosts -}}
{{- printf "mongodb://%s/%s?%s" $serverList .Values.mongodb.database $connParamsStr -}}
{{- end -}}

{{/*
Create ELK hosts string
*/}}
{{- define "elkHosts" -}}
{{- $serverList :=include "_parseHosts" .Values.global.elasticsearch.hosts -}}
{{- printf "%s" $serverList -}}
{{- end -}}

{{/*
Create RabbitMQ hosts string
*/}}
{{- define "RmqHosts" -}}
{{- $serverList :=include "_parseHosts" .Values.global.rabbitmq.hosts -}}
{{- printf "%s" $serverList -}}
{{- end -}}

{{/*
Create Redis hosts string
*/}}
{{- define "RedisHosts" -}}
{{- $serverList :=include "_parseHosts" .Values.global.redis.hosts -}}
{{- printf "%s" $serverList -}}
{{- end -}}

{{/*
Create shared sidecar entries
*/}}
{{- define "sharedSidecar" -}}
{{- $entries := .Values.sidecar.shared -}}
{{- range $entries }}
{{- $item := . }}
{{- if hasKey $.Values.global $item }}
{{- $entry := pluck $item $.Values.global | first }}
{{- $hosts := $entry.hosts }}
{{- if $hosts }}
{{- range $hosts }}
{{- printf "- \"*/%s\"" .host | nindent 4 }}
{{- end }}
{{- end }}
{{- if $entry.host }}
{{- printf "- \"*/%s\"" $entry.host | nindent 4 }}
{{- end }}
{{- end }}
{{- end }}
{{- end -}}