import CalculationReference.CalculationSyncStub;
import TransactionApi.Structures.TransactionStatusResponse;
import TransactionApi.TransactionApi;
import com.google.gson.GsonBuilder;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.NamedValue;
import org.apache.axis2.databinding.types.NormalizedString;
import org.json.simple.JSONObject;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import utils.ClientCredentialsRequest;
import utils.IdentityServerClient;
import utils.IntrospectRequest;
import utils.PasswordTokenRequest;

import javax.xml.stream.XMLStreamException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.*;

public class SoapExample {

    private final IdentityServerClient identityServerClient;
    private String baseAddress;
    private String transactionId;
	private String accessToken;

    public SoapExample() {
        //this.baseAddress = "https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithoutScope/v1_0/"; //testa vides SOAP servisa adrese bez scope
        this.baseAddress = "https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope/v1_0/"; //testa vides SOAP servisa adrese ar scope
		String identityAddress = "https://apitestgw.vraa.gov.lv/token"; //VISS testa vide
        String introspectionAddress = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/introspect"; //VISS Testa vides introspect
        String jwtPayloadAudience = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/token"; //VISS testa vide
        String clientId = "16dac182-af92-4916-8fee-047b313039f5"; //Lietojuma Consumer_key no API Store.
        String clientSecret = "954fa33e2ac7b5f3ca6a196f5cddd6395ed7199c3e448f4336973e032ac7931d"; //Lietojuma consumer_secret no API Store
        String userName = "lietotajvards"; //PFAS AUTH lietotajvards
        String password = "lietotaja_parole"; //PFAS AUTH lietotaja parole
        String grantType = "password";
        String clientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
        String grantTypeClient = "client_credentials";
        String clientAssertion = null;
        String scope = "ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope-v1_0-Calc"; //Ja SOAP servisi ir aizsargati ar scope, tad seit tiek uzskaititi izsaucamo servisu scope/operacijas
        String transactionApiAddress = "https://vissapi-test.vraa.gov.lv/ApiManagement.TransactionApi/";
        String eServiceId = "URN:IVIS:100001:EP-EP889-v1-0";
		
		//Scope-operacijas ir japievieno PFAS Uzticamo pusu saskarne - aplikacijam, ar kuram lietotajs ir parakstits uz servisu un veiks aizsargato API/servisu izsaukumus.
        String certificatePath ="C:\\OpenSSL-Win64\\bin\\sertifikata_nosaukums.pfx"; //sertifikata direktorija
        String certificatePassword = "parole"; //sertifikata parole

		/* Lai datu nemeja autentifikacijam pieskirt Scope/atlaujas uz konkretiem servisiem - ir jabut Datu deveja atlaujam.
	    Piemera noraditie Scope/operacijas ir paredzeti SOAP servisam:
	    https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope/v1_0
	    Lai no mineta servisa sanemt rezultatu, ir nepieciesams
	    1)API Store ar TOKEN_CLIENT_ID noradito Klienta lietojumu pierakstities (subscribe) uz so servisu
	    2)PFAS Uzticamo pusu parvaldibas saskarne pievienot Scope/atlaujas lietotaja aplikacijai */

        try (FileInputStream stream = new FileInputStream(certificatePath)){
            KeyStore store = KeyStore.getInstance("pkcs12", "SunJSSE");
            char[] keyStorePassword = certificatePassword.toCharArray();
            store.load(stream, keyStorePassword);

            Enumeration<String> aliases = store.aliases();
            String alias = aliases.hasMoreElements() ? aliases.nextElement() : null;

            X509Certificate certificate = (X509Certificate)store.getCertificate(alias);
            byte[] certificateEncoded = certificate.getEncoded();
            PrivateKey key = (PrivateKey) store.getKey(alias, keyStorePassword);

            JwtBuilder builder = Jwts.builder()
                    .setId(UUID.randomUUID().toString())
                    .setSubject(clientId)
                    .setIssuer(clientId)
                    .setAudience(jwtPayloadAudience)
                    .setExpiration(new Date(new Date().getTime() + 2 * 3600*1000))
                    .setNotBefore( new Date())
                    .setHeaderParam("x5c", certificateEncoded)
                    .signWith(key, SignatureAlgorithm.RS256);
            clientAssertion = builder.compact();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (CertificateException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (NoSuchProviderException e) {
            e.printStackTrace();
        } catch (KeyStoreException e) {
            e.printStackTrace();
        } catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }

        this.identityServerClient = new IdentityServerClient(
                new PasswordTokenRequest(identityAddress, clientId, clientSecret, userName, password, grantType, scope),
                new ClientCredentialsRequest(identityAddress, clientId, clientSecret, clientAssertionType, clientAssertion, grantTypeClient, scope),
                new IntrospectRequest(introspectionAddress, clientId, clientSecret));
        accessToken = identityServerClient.getAccessTokenClientCredentials(); //ja autentifikacijai tiek izmantots sertifikats              
        //accessToken = identityServerClient.getAccessTokenPassword(); //izsaukumiem ar logins un parole
        JSONObject introspectResponse = identityServerClient.getIntrospection(accessToken);
        System.out.println("Introspection response for token " + accessToken);
        System.out.println(introspectResponse.toString());
        System.out.println();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(transactionApiAddress)
                .addConverterFactory(GsonConverterFactory.create(new GsonBuilder().create()))
                .build();
        TransactionApi transactionApi = retrofit.create(TransactionApi.class);
        try {
            TransactionStatusResponse transactionStatus = transactionApi.Start(eServiceId, "Bearer " + accessToken).execute().body();
            transactionId = transactionStatus.getTansactionId();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void Run() {
    	System.out.println();
    	Multiply();
        System.out.println();
        Divide();
        System.out.println();
    }

    private void Multiply(){
        try {
            CalculationSyncStub.RequestHeaderStructure header = new CalculationSyncStub.RequestHeaderStructure();

            CalculationSyncStub.UUIDType messageId = new CalculationSyncStub.UUIDType();
            messageId.setUUIDType("6cafe2c6-9834-47ad-b710-be8033710b02");
            header.setMessageID(messageId);

            CalculationSyncStub.URNType messageType = new CalculationSyncStub.URNType();
            messageType.setURNType("URN:IVIS:100001:XSD-Testing-TestISServise-v1-0-TYPE-Calculation");
            header.setMessageType(messageType);

            CalculationSyncStub.URNType transactionID = new CalculationSyncStub.URNType();
            transactionID.setURNType(transactionId);
            header.setTransactionID(transactionID);

            CalculationSyncStub.UUIDType correlationID = new CalculationSyncStub.UUIDType();
            correlationID.setUUIDType("f4ceae8a-dfd9-48b3-a0b6-5d990aaac86e");
            header.setCorrelationID(correlationID);

            CalculationSyncStub.URNType destination = new CalculationSyncStub.URNType();
            destination.setURNType("URN:IVIS:100001:ISS-SIA.ABC-CalculationDataSync-v1-0");
            header.setDestination(destination);

            CalculationSyncStub.URNType milestoneID = new CalculationSyncStub.URNType();
            milestoneID.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setMilestoneID(milestoneID);

            CalculationSyncStub.URNType nextMilestoneID = new CalculationSyncStub.URNType();
            nextMilestoneID.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setNextMilestoneID(nextMilestoneID);

            CalculationSyncStub.URNType responseEndPoint = new CalculationSyncStub.URNType();
            responseEndPoint.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setResponseEndPoint(responseEndPoint);

            CalculationSyncStub.ParticipantStructure participant = new CalculationSyncStub.ParticipantStructure();
            CalculationSyncStub.URNType systemID = new CalculationSyncStub.URNType();
            systemID.setURNType("URN:IVIS:100001:PORTAL-Unknown");
            participant.setSystemID(systemID);

            CalculationSyncStub.ParticipantStructureChoice_type0 participantStructureChoice_type0 = new CalculationSyncStub.ParticipantStructureChoice_type0();
            CalculationSyncStub.InhabitantStructure inhabitant = new CalculationSyncStub.InhabitantStructure();

            CalculationSyncStub.PersonCodeType personCode = new CalculationSyncStub.PersonCodeType();
            personCode.setPersonCodeType("12345678901"); //lietotaja personas kods
            inhabitant.setPersonCode(personCode);

            CalculationSyncStub.PersonIDStructure personID = new CalculationSyncStub.PersonIDStructure();
            personID.setScheme(new NormalizedString("urn:ivis:100001:name.id-viss"));
            personID.setNormalizedString(new NormalizedString("PK:12345678901")); //lietotaja personas kods
            inhabitant.setPersonID(personID);

            CalculationSyncStub.PersonFullNameStructure personFullName = new CalculationSyncStub.PersonFullNameStructure();
            CalculationSyncStub.FirstNameType firstName = new CalculationSyncStub.FirstNameType();
            firstName.setFirstNameType(new NormalizedString( "Vards")); //lietotaja vards
            personFullName.setFirstName(firstName);
            CalculationSyncStub.LastNameType lastName = new CalculationSyncStub.LastNameType();
            lastName.setLastNameType(new NormalizedString("Uzvards")); //lietotaja uzvards
            personFullName.setLastName(lastName);
            inhabitant.setFullName(personFullName);

            participantStructureChoice_type0.setInhabitant(inhabitant);
            participant.setParticipantStructureChoice_type0(participantStructureChoice_type0);
            header.setSender(participant);

            CalculationSyncStub.Body_type0 body = new CalculationSyncStub.Body_type0();
            body.setExtraElement(AXIOMUtil.stringToOM(
                    "<Calculation xmlns=\"http://ivis.eps.gov.lv/XMLSchemas/100000/TestISServise/v1-0\">" +
                                    "<Number1>50</Number1>" +
                                    "<Number2>6</Number2>" +
                                    "<Operation>multiplication</Operation>" +
                                "</Calculation>"));

            CalculationSyncStub.IVISRequestStructure request = new CalculationSyncStub.IVISRequestStructure();
            request.setHeader(header);
            request.setBody(body);
            CalculationSyncStub.DefaultMethodSync defaultMethodSync = new CalculationSyncStub.DefaultMethodSync();
            defaultMethodSync.setIVISRequest(request);

            CalculationSyncStub client = new CalculationSyncStub(this.baseAddress);
            ServiceClient sc = client._getServiceClient();

            Options options = new Options();
            List<NamedValue> namedValuePairs = new ArrayList<NamedValue>();
            namedValuePairs.add(new NamedValue("Authorization", "Bearer " + accessToken));
            namedValuePairs.add(new NamedValue("x-transactionId", transactionId));
            options.setProperty(org.apache.axis2.transport.http.HTTPConstants.HTTP_HEADERS, namedValuePairs);
            options.setTo(new EndpointReference(this.baseAddress));
            sc.setOptions(options);

            CalculationSyncStub.DefaultMethodSyncResponse response = client.defaultMethodSync(defaultMethodSync);
            System.out.println(response.getIVISResponse().getBody().getExtraElement().toString());
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (XMLStreamException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void Divide(){
        try {
            CalculationSyncStub.RequestHeaderStructure header = new CalculationSyncStub.RequestHeaderStructure();

            CalculationSyncStub.UUIDType messageId = new CalculationSyncStub.UUIDType();
            messageId.setUUIDType("6cafe2c6-9834-47ad-b710-be8033710b02");
            header.setMessageID(messageId);

            CalculationSyncStub.URNType messageType = new CalculationSyncStub.URNType();
            messageType.setURNType("URN:IVIS:100001:XSD-Testing-TestISServise-v1-0-TYPE-Calculation");
            header.setMessageType(messageType);

            CalculationSyncStub.URNType transactionID = new CalculationSyncStub.URNType();
            transactionID.setURNType(transactionId);
            header.setTransactionID(transactionID);

            CalculationSyncStub.UUIDType correlationID = new CalculationSyncStub.UUIDType();
            correlationID.setUUIDType("f4ceae8a-dfd9-48b3-a0b6-5d990aaac86e");
            header.setCorrelationID(correlationID);

            CalculationSyncStub.URNType destination = new CalculationSyncStub.URNType();
            destination.setURNType("URN:IVIS:100001:ISS-SIA.ABC-CalculationDataSync-v1-0");
            header.setDestination(destination);

            CalculationSyncStub.URNType milestoneID = new CalculationSyncStub.URNType();
            milestoneID.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setMilestoneID(milestoneID);

            CalculationSyncStub.URNType nextMilestoneID = new CalculationSyncStub.URNType();
            nextMilestoneID.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setNextMilestoneID(nextMilestoneID);

            CalculationSyncStub.URNType responseEndPoint = new CalculationSyncStub.URNType();
            responseEndPoint.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setResponseEndPoint(responseEndPoint);

            CalculationSyncStub.ParticipantStructure participant = new CalculationSyncStub.ParticipantStructure();
            CalculationSyncStub.URNType systemID = new CalculationSyncStub.URNType();
            systemID.setURNType("URN:IVIS:100001:PORTAL-Unknown");
            participant.setSystemID(systemID);

            CalculationSyncStub.ParticipantStructureChoice_type0 participantStructureChoice_type0 = new CalculationSyncStub.ParticipantStructureChoice_type0();
            CalculationSyncStub.InhabitantStructure inhabitant = new CalculationSyncStub.InhabitantStructure();

            CalculationSyncStub.PersonCodeType personCode = new CalculationSyncStub.PersonCodeType();
            personCode.setPersonCodeType("12345678901"); //Lietotaja personas kods
            inhabitant.setPersonCode(personCode);

            CalculationSyncStub.PersonIDStructure personID = new CalculationSyncStub.PersonIDStructure();
            personID.setScheme(new NormalizedString("urn:ivis:100001:name.id-viss"));
            personID.setNormalizedString(new NormalizedString("PK:12345678901")); //Lietotaja personas kods
            inhabitant.setPersonID(personID);

            CalculationSyncStub.PersonFullNameStructure personFullName = new CalculationSyncStub.PersonFullNameStructure();
            CalculationSyncStub.FirstNameType firstName = new CalculationSyncStub.FirstNameType();
            firstName.setFirstNameType(new NormalizedString( "Vards")); //Lietotaja vards
            personFullName.setFirstName(firstName);
            CalculationSyncStub.LastNameType lastName = new CalculationSyncStub.LastNameType();
            lastName.setLastNameType(new NormalizedString("Uzvards")); //Lietotaja uzvards
            personFullName.setLastName(lastName);
            inhabitant.setFullName(personFullName);

            participantStructureChoice_type0.setInhabitant(inhabitant);
            participant.setParticipantStructureChoice_type0(participantStructureChoice_type0);
            header.setSender(participant);

            CalculationSyncStub.Body_type0 body = new CalculationSyncStub.Body_type0();
            body.setExtraElement(AXIOMUtil.stringToOM(
                    "<Calculation xmlns=\"http://ivis.eps.gov.lv/XMLSchemas/100000/TestISServise/v1-0\">" +
                            "<Number1>20</Number1>" +
                            "<Number2>2</Number2>" +
                            "<Operation>division</Operation>" +
                            "</Calculation>"));

            CalculationSyncStub.IVISRequestStructure request = new CalculationSyncStub.IVISRequestStructure();
            request.setHeader(header);
            request.setBody(body);
            CalculationSyncStub.DefaultMethodSync defaultMethodSync = new CalculationSyncStub.DefaultMethodSync();
            defaultMethodSync.setIVISRequest(request);

            CalculationSyncStub client = new CalculationSyncStub(this.baseAddress);
            ServiceClient sc = client._getServiceClient();

            Options options = new Options();
            List<NamedValue> namedValuePairs = new ArrayList<NamedValue>();
            namedValuePairs.add(new NamedValue("Authorization", "Bearer " + accessToken));
            namedValuePairs.add(new NamedValue("x-transactionId", transactionId));
            options.setProperty(org.apache.axis2.transport.http.HTTPConstants.HTTP_HEADERS, namedValuePairs);
            options.setTo(new EndpointReference(this.baseAddress));
            sc.setOptions(options);

            CalculationSyncStub.DefaultMethodSyncResponse response = client.defaultMethodSync(defaultMethodSync);
            System.out.println(response.getIVISResponse().getBody().getExtraElement().toString());
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (XMLStreamException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
