package utils;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;

import java.util.List;

public class IntrospectResponse {
    @SerializedName(value = "active")
    private Boolean active;

    @SerializedName(value = "exp")
    private Long exp;

    @SerializedName(value = "family_name")
    private String familyName;

    @SerializedName(value = "given_name")
    private String givenName;

    @SerializedName(value = "sub")
    private String sub;

    @SerializedName(value = "sid")
    private String sid;

    @SerializedName(value = "nbf")
    private Long nbf;

    @SerializedName(value = "scp")
    private String[] scope;

    @SerializedName(value = "aud")
    @JsonAdapter(AlwaysListTypeAdapterFactory.class)
    private List<String> audience;

    @SerializedName(value = "amr")
    private String amr;

    public String amr() { return this.amr; }
    public IntrospectResponse withAmr(String amr) {
        this.amr = amr;
        return this;
    }

    public Boolean active() {
        return this.active;
    }
    public IntrospectResponse withActive(Boolean active) {
        this.active = active;
        return this;
    }

    public Long exp() {
        return this.exp;
    }
    public IntrospectResponse withExp(Long exp) {
        this.exp = exp;
        return this;
    }

    public String givenName() {
        return this.givenName;
    }
    public IntrospectResponse withGivenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    public String familyName() {
        return this.familyName;
    }
    public IntrospectResponse withFamilyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    public String sub() {
        return this.sub;
    }
    public IntrospectResponse withSub(String sub) {
        this.sub = sub;
        return this;
    }

    public Long nbf() {
        return this.nbf;
    }
    public IntrospectResponse withNbf(Long nbf) {
        this.nbf = nbf;
        return this;
    }

    public String sid() {
        return this.sid;
    }
    public IntrospectResponse withNbf(String sid) {
        this.sid = sid;
        return this;
    }

    public String[] scope() {
        return this.scope;
    }
    public IntrospectResponse withNbf(String[] scope) {
        this.scope = scope;
        return this;
    }

    public List<String> audience() {
        return this.audience;
    }
    public IntrospectResponse withAudience(List<String> audience) {
        this.audience = audience;
        return this;
    }

}

