package utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;

public class IdentityServerClient {
    private final PasswordTokenRequest passwordTokenRequest;
    private final ClientCredentialsRequest clientCredentialsRequest;
    private final IntrospectRequest introspectRequest;
    private final GsonBuilder gsonBuilder;

    public IdentityServerClient(PasswordTokenRequest passwordTokenRequest, ClientCredentialsRequest clientCredentialsRequest, IntrospectRequest introspectRequest) {
        this.passwordTokenRequest = passwordTokenRequest;
        this.clientCredentialsRequest = clientCredentialsRequest;
        this.introspectRequest = introspectRequest;
        this.gsonBuilder = new GsonBuilder();
    }

    public String getAccessTokenClientCredentials(){
        String accessToken = null;
        BufferedReader reader = null;

        HttpClient client = new DefaultHttpClient();
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("grant_type=" + clientCredentialsRequest.getGrantType());
            builder.append("&client_assertion_type=" + URLEncoder.encode(clientCredentialsRequest.getClientAssertionType(), StandardCharsets.UTF_8));
            builder.append("&client_assertion=" + URLEncoder.encode(clientCredentialsRequest.getClientAssertion(), StandardCharsets.UTF_8));
            builder.append("&scope=" + URLEncoder.encode(clientCredentialsRequest.getScope(), StandardCharsets.UTF_8));

            HttpPost httpPost = new HttpPost(clientCredentialsRequest.getAddress());
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setHeader("Authorization", "Basic " + new String(Base64.encodeBase64((clientCredentialsRequest.getClientId() + ":" + clientCredentialsRequest.getClientSecret()).getBytes("UTF-8"))));
            httpPost.setEntity(new StringEntity(builder.toString(), "UTF-8"));
            HttpResponse response = client.execute(httpPost);
            int responseCode = response.getStatusLine().getStatusCode();
            JSONObject parsedObject;
            HttpEntity entity = response.getEntity();
            reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));

            if (responseCode == HttpStatus.SC_OK) {
                parsedObject = getParsedObjectByReader(reader);
                if (parsedObject != null) {
                    accessToken = parsedObject.get("access_token").toString();
                } else {
                    throw new Exception("ParseObject is empty.");
                }
            } else {
                throw new Exception("Some thing wrong here when getting TokenMetaData" + ". Error " + "code" + responseCode);
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (org.json.simple.parser.ParseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
            client.getConnectionManager().shutdown();
        }
        return accessToken;
    }

    public String getAccessTokenPassword(){
        String accessToken = null;
        BufferedReader reader = null;

        HttpClient client = new DefaultHttpClient();

        try {
            StringBuilder builder = new StringBuilder();
            builder.append("grant_type=" + passwordTokenRequest.getGrantType());
            builder.append("&username=" + URLEncoder.encode(passwordTokenRequest.getUserName(), StandardCharsets.UTF_8));
            builder.append("&password=" + URLEncoder.encode(passwordTokenRequest.getPassword(), StandardCharsets.UTF_8));
            builder.append("&scope=" + URLEncoder.encode(passwordTokenRequest.getScope(), StandardCharsets.UTF_8));

            HttpPost httpPost = new HttpPost(passwordTokenRequest.getAddress());
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setHeader("Authorization", "Basic " + new String(Base64.encodeBase64((passwordTokenRequest.getClientId() + ":" + passwordTokenRequest.getClientSecret()).getBytes("UTF-8"))));
            httpPost.setEntity(new StringEntity(builder.toString(), "UTF-8"));
            HttpResponse response = client.execute(httpPost);
            int responseCode = response.getStatusLine().getStatusCode();
            JSONObject parsedObject;
            HttpEntity entity = response.getEntity();
            reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));

            if (responseCode == HttpStatus.SC_OK) {
                parsedObject = getParsedObjectByReader(reader);
                if (parsedObject != null) {
                    accessToken = parsedObject.get("access_token").toString();
                } else {
                    throw new Exception("ParseObject is empty.");
                }
            } else {
                throw new Exception("Some thing wrong here when getting TokenMetaData" + ". Error " + "code" + responseCode);
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (org.json.simple.parser.ParseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
            client.getConnectionManager().shutdown();
        }

        return accessToken;
    }

    public IntrospectResponse getIntrospectionModel(String accessToken) {
        IntrospectResponse introspect = null;
        if (accessToken == null || accessToken.isEmpty()) {
            return  introspect;
        }
        BufferedReader reader = null;
        HttpClient client = new DefaultHttpClient();

        try {
            StringBuilder builder = new StringBuilder();
            builder.append("token=" + accessToken);

            HttpPost httpPost = new HttpPost(this.introspectRequest.getAddress());
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setHeader("Authorization", "Basic " + new String(Base64.encodeBase64((this.introspectRequest.getClientId() + ":" + this.introspectRequest.getClientSecret()).trim().getBytes("UTF-8"))));
            httpPost.setEntity(new StringEntity(builder.toString(), "UTF8"));
            HttpResponse response = client.execute(httpPost);
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
            if (responseCode == HttpStatus.SC_CREATED || responseCode == HttpStatus.SC_OK) {
                Gson gson = gsonBuilder.create();
                introspect = gson.fromJson(reader, IntrospectResponse.class);
            } else {
                throw new Exception("Some thing wrong here when getting TokenMetaData" + ". Error " + "code" + responseCode);
            }
        } catch (IOException e) {
            System.out.println("Error while reading response body from Server : " + e.getMessage());
        } catch (ParseException e) {
            System.out.println("Error while parsing response json : " + e.getMessage());
        } catch (Exception e) {
            System.out.println("Error : " + e.getMessage());
        } finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
            client.getConnectionManager().shutdown();
        }
        return introspect;
    }

    public JSONObject getIntrospection(String accessToken) {
        JSONObject introspect = null;
        if (accessToken == null || accessToken.isEmpty()) {
            return  introspect;
        }
        BufferedReader reader = null;
        HttpClient client = new DefaultHttpClient();

        try {
            StringBuilder builder = new StringBuilder();
            builder.append("token=" + accessToken);

            HttpPost httpPost = new HttpPost(this.introspectRequest.getAddress());
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setHeader("Authorization", "Basic " + new String(Base64.encodeBase64((this.introspectRequest.getClientId() + ":" + this.introspectRequest.getClientSecret()).trim().getBytes("UTF-8"))));
            httpPost.setEntity(new StringEntity(builder.toString(), "UTF8"));
            HttpResponse response = client.execute(httpPost);
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
            if (responseCode == HttpStatus.SC_CREATED || responseCode == HttpStatus.SC_OK) {
                introspect = getParsedObjectByReader(reader);
            } else {
                throw new Exception("Some thing wrong here when getting TokenMetaData" + ". Error " + "code" + responseCode);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
            client.getConnectionManager().shutdown();
        }
        return introspect;
    }

    private JSONObject getParsedObjectByReader(BufferedReader reader) throws org.json.simple.parser.ParseException, IOException {

        JSONObject parsedObject = null;
        JSONParser parser = new JSONParser();
        if (reader != null) {
            parsedObject = (JSONObject) parser.parse(reader);
        }
        return parsedObject;
    }
}
