import TransactionApi.Structures.TransactionStatus;
import TransactionApi.Structures.TransactionStatusResponse;
import TransactionApi.TransactionApi;
import com.google.gson.GsonBuilder;
import io.jsonwebtoken.*;
import io.jsonwebtoken.security.Keys;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.DateUtils;
import org.json.simple.JSONObject;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import utils.*;

import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.*;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.UUID;

import static javax.crypto.Cipher.SECRET_KEY;

public class RestExample {

    private final IdentityServerClient identityServerClient;
    private String baseAddress;
    private String transactionId;
    private String accessToken;

    public RestExample() {
        this.baseAddress = "https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithScope/v1_0/"; //testa vides REST servisa adrese ar scope
        //this.baseAddress = "https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithoutScope/v1_0/"; //testa vides REST servisa adrese bez scope
        String identityAddress = "https://apitestgw.vraa.gov.lv/token"; //VISS Testa vide
        String introspectionAddress = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/introspect"; //VISS Testa introspect
        String jwtPayloadAudience = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/token"; //VISS testa vide
        String clientId = "16dac182-af92-4916-8fee-047b313039f5"; //Lietojuma Consumer_key no API Store.
        String clientSecret = "954fa33e2ac7b5f3ca6a196f5cddd6395ed7199c3e448f4336973e032ac7931d"; //Lietojuma consumer_secret no API Store
        String userName = "lietotajvards"; //PFAS AUTH lietotajvards
        String password = "lietotaja_parole"; //PFAS AUTH lietotaja parole
        String grantType = "password";
        String clientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
        String grantTypeClient = "client_credentials";
        String clientAssertion = null;
        String scope = "API-RAPLM_VRAA-CalculationApiForTestsWithScope-v1_0-Multiply API-RAPLM_VRAA-CalculationApiForTestsWithScope-v1_0-Divide"; //Ja API vai servisi ir aizsargati ar scope, tad seit tiek uzskaititi izsaucamo servisu scope/operacijas.
        String transactionApiAddress = "https://vissapi-test.vraa.gov.lv/ApiManagement.TransactionApi/";
        String eServiceId = "URN:IVIS:100001:EP-EP889-v1-0";
		//Scope-operacijas ir japievieno PFAS Uzticamo pusu saskarne - aplikacijam, ar kuram lietotajs ir parakstits uz servisu un veiks aizsargato API/servisu izsaukumus.

		/* PFAS AUTH lietotaja autentifikacijas sertifikats, sertifikats ir registrets PFAS ka autentifikacijas lidzeklis */
        String certificatePath ="C:\\OpenSSL-Win64\\bin\\sertifikata_nosaukums.pfx"; //sertifikata direktorija
        String certificatePassword = "parole"; //sertifikata parole
        
        /* Lai datu nemeja autentifikacijam pieskirt Scope/atlaujas uz konkretiem servisiem - ir jabut Datu deveja atÄ¼aujam.
	    Piemera noraditie Scope/operacijas ir paredzeti API/servisam:
	    https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithScope/v1_0/ 
	    Lai no mineta servisa saÅ†emt rezultatu, ir nepieciesams
	    1)API Store ar TOKEN_CLIENT_ID noradito Klienta lietojumu pierakstities (subscribe) uz so servisu
	    2)PFAS Uzticamo pusu parvaldibas saskarne pievienot Scope/atlaujas lietotaja aplikacijai  */
        
        try (FileInputStream stream = new FileInputStream(certificatePath)){
            KeyStore store = KeyStore.getInstance("pkcs12", "SunJSSE");
            char[] keyStorePassword = certificatePassword.toCharArray();
            store.load(stream, keyStorePassword);

            Enumeration<String> aliases = store.aliases();
            String alias = aliases.hasMoreElements() ? aliases.nextElement() : null;

            X509Certificate certificate = (X509Certificate)store.getCertificate(alias);
            byte[] certificateEncoded = certificate.getEncoded();
            PrivateKey key = (PrivateKey) store.getKey(alias, keyStorePassword);

            JwtBuilder builder = Jwts.builder()
                    .setId(UUID.randomUUID().toString())
                    .setSubject(clientId)
                    .setIssuer(clientId)
                    .setAudience(jwtPayloadAudience)
                    .setExpiration(new Date(new Date().getTime() + 2 * 3600*1000))
                    .setNotBefore( new Date())
                    .setHeaderParam("x5c", certificateEncoded)
                    .signWith(key, SignatureAlgorithm.RS256);
            clientAssertion = builder.compact();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (CertificateException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (NoSuchProviderException e) {
            e.printStackTrace();
        } catch (KeyStoreException e) {
            e.printStackTrace();
        } catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }

        this.identityServerClient = new IdentityServerClient(
                new PasswordTokenRequest(identityAddress, clientId, clientSecret, userName, password, grantType, scope ),
                new ClientCredentialsRequest(identityAddress, clientId, clientSecret, clientAssertionType, clientAssertion, grantTypeClient, scope),
                new IntrospectRequest(introspectionAddress, clientId, clientSecret));

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(transactionApiAddress)
                .addConverterFactory(GsonConverterFactory.create(new GsonBuilder().create()))
                .build();
        TransactionApi transactionApi = retrofit.create(TransactionApi.class);
        try {
            TransactionStatusResponse transactionStatus = transactionApi.Start(eServiceId).execute().body();
            transactionId = transactionStatus.getTansactionId();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }


    public void Run() {
    	System.out.println();
    	Multiply();
        System.out.println();
        Divide();
        System.out.println();
    }

    private void Multiply() {
        BufferedReader reader = null;
        HttpClient client = new DefaultHttpClient();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Multiplier", 15);
            jsonObject.put("Multiplicand", 20);

			//getAccessTokenPassword(); //identityServerClient.getAccessTokenClientCredentials();
            accessToken = identityServerClient.getAccessTokenClientCredentials(); //ja autentifikacijai tiek izmantots sertifikats 
            //accessToken = identityServerClient.getAccessTokenPassword(); //ja autentifikacijai tiek izmantots lietotajvards/parole
			JSONObject introspectResponse = identityServerClient.getIntrospection(accessToken);
            System.out.println("Introspection response for token " + accessToken);
            System.out.println(introspectResponse.toString());
            System.out.println();

            HttpPost httpPost = new HttpPost(baseAddress + "api/Calculator/Multiply");
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Authorization", "Bearer " + accessToken);
            httpPost.setHeader("x-transactionId", transactionId);
            httpPost.setEntity(new StringEntity(jsonObject.toString(), "UTF-8"));
            HttpResponse response = client.execute(httpPost);
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));

            if (responseCode == HttpStatus.SC_OK) {
                String line;
                while((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            } else {
                throw new Exception("Some thing wrong here when requesting Multiply" + ". Error " + "code" + responseCode);
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
            client.getConnectionManager().shutdown();
        }
    }

    private void Divide() {
        BufferedReader reader = null;
        HttpClient client = new DefaultHttpClient();

        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Dividend", 100);
            jsonObject.put("Divisor", 20);

            //String accessToken = identityServerClient.getAccessTokenClientCredentials(); //ja autentifikacijai tiek izmantots sertifikats
            String accessToken = identityServerClient.getAccessTokenPassword(); //ja autentifikacijai tiek izmantots lietotajvards/parole 
			JSONObject introspectResponse = identityServerClient.getIntrospection(accessToken);
            System.out.println("Introspection response for token " + accessToken);
            System.out.println(introspectResponse.toString());
            System.out.println();

            HttpPost httpPost = new HttpPost(baseAddress + "api/Calculator/Divide");
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Authorization", "Bearer " + accessToken);
            httpPost.setHeader("x-transactionId", transactionId);
            httpPost.setEntity(new StringEntity(jsonObject.toString(), "UTF-8"));
            HttpResponse response = client.execute(httpPost);
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));

            if (responseCode == HttpStatus.SC_OK) {
                String line;
                while((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            } else {
                throw new Exception("Some thing wrong here when requesting Divide" + ". Error " + "code" + responseCode);
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
            client.getConnectionManager().shutdown();
        }
    }

}
