﻿using IdentityModel.Client;
using Microsoft.IdentityModel.Tokens;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IdentityModel.Tokens;
using System.IdentityModel.Tokens.Jwt;
using System.IO;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Reflection;
using System.Security.Claims;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;
using Viss.ApiManagement.Samples.TransactionApi;
using Viss.ApiManagement.Samples.Utils;

namespace Viss.ApiManagement.Samples
{
    public class RestExample
    {
        private readonly HttpClient client;

        public RestExample()
        {
            string baseAddress = "https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithScope/v1_0/"; //testa vides REST servisa adrese ar scope
            //string baseAddress = "https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithoutScope/v1_0/"; //testa vides REST servisa adrese bez scope
            //string baseAddress = "https://apitestgw.vraa.gov.lv/legalentity/v1.0/"; //testa vides REST servisa adrese bez scope
            string identityAddress = "https://apitestgw.vraa.gov.lv/token"; //VISS Testa vide
            string introspectionAddress = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/introspect"; //VISS Testa introspect
            string jwtPayloadAudience = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/token"; //VISS testa vide
            string clientId = "f3737977-e9ee-437e-bc86-8710668ff4fb"; //Lietojuma Consumer_key no API Store.
            string clientSecret = "21d43ea06abb8d3c473285b8d20ac4435f12013n02a814faz437725ae38c32812"; //Lietojuma consumer_secret no API Store
            string userName = "username"; //PFAS AUTH lietotaja logins
            string password = "password"; //PFAS AUTH lietotāja parole
            string grantType = "password";
            ClientCredentialStyle clientCredentialStyle = ClientCredentialStyle.PostBody;
            string pathnameprivkeyfile = @"C:\\Users\\user\\Desktop\\certificate.pfx"; //sertifikata fails
            string passwordprivkey = "certpassword"; //sertifikata parole
            string scope = "API-RAPLM_VRAA-CalculationApiForTestsWithScope-v1_0-Multiply API-RAPLM_VRAA-CalculationApiForTestsWithScope-v1_0-Divide"; //Ja API vai servisi ir aizsargati ar scope, tad seit tiek uzskaititi izsaucamo servisu scope/operacijas.
            string transactionApiAddress = "https://vissapi-test.vraa.gov.lv/ApiManagement.TransactionApi";
            string eServiceId = "URN:IVIS:100001:EP-EP889-v1-0";
            //Scope-operacijas ir japievieno PFAS Uzticamo pusu saskarne - aplikacijām, ar kuram lietotajs ir parakstits uz servisu un veiks aizsargato API/servisu izsaukumus.

            /* PFAS AUTH lietotaja autentifikacijas sertifikats, sertifikats ir registrets PFAS ka autentifikacijas lidzeklis */
            var clientCertificate = new X509Certificate2(pathnameprivkeyfile, passwordprivkey);

            /* Lai datu nemeja autentifikacijam pieskirt Scope/atlaujas uz konkretiem servisiem - ir jabut Datu deveja atlaujam.
                 Piemera noraditie Scope/operacijas ir paredzeti API/servisam:
                 https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithScope/v1_0/ 
                 Lai no minēta servisa saņemt rezultatu, ir nepieciešams
	            1)API Store ar TOKEN_CLIENT_ID noradito Klienta lietojumu pierakstities (subscribe) uz so servisu
	            2)PFAS Uzticamo pusu parvaldibas saskarne pievienot Scope/atlaujas lietotaja aplikacijai */

            /* Ir nokonfigurets lai tika izmantots sertifikats. Gadijuma ja ir nepieciesams veikt izsaukumus izmantojot username+pass, 
           * ir nepieciesams izveleties AuthenticationHandler.cs 31/32 rindu -> GetAccessTokenClientCredentials();) vai -> GetAccessTokenPassword();) 
           * un atkomentet rindu 30. 
           * Papildus SoapExample.cs vajag atkomentet 189 rindu, ieraksts (//TokenResponse tokenResponse = await identityServerClient.GetAccessTokenClientCredentials();) */

            var validFrom = DateTime.UtcNow;
            var validTo = validFrom + TimeSpan.FromSeconds(60000.0);
            var jwtHeader = new JwtHeader(new Microsoft.IdentityModel.Tokens.X509SigningCredentials(clientCertificate))
            {
                ["x5c"] = Convert.ToBase64String(clientCertificate.GetRawCertData())
            };
            var jwtPayload = new JwtPayload(
                issuer: clientId,
                audience: jwtPayloadAudience,
                claims: new List<Claim>() { new Claim("sub", clientId), new Claim("id", Guid.NewGuid().ToString()) },
                notBefore: validFrom,
                expires: validTo
                );
            var jwt = new JwtSecurityToken(jwtHeader, jwtPayload);
            var handler = new JwtSecurityTokenHandler();
            var assertion = handler.WriteToken(jwt);

            IdentityServerClient identityServerClient = new IdentityServerClient(
                new PasswordTokenRequest()
                {
                    Address = identityAddress,
                    ClientId = clientId,
                    ClientSecret = clientSecret,
                    UserName = userName,
                    Password = password,
                    GrantType = grantType,
                    Scope = scope,
                    ClientCredentialStyle = clientCredentialStyle
                },
                new ClientCredentialsTokenRequest()
                {
                    Address = identityAddress,
                    ClientId = clientId,
                    ClientSecret = clientSecret,
                    Scope = scope,
                    ClientAssertion = new ClientAssertion()
                    {
                        Type = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer",
                        Value = assertion,
                    }
                },
                new TokenIntrospectionRequest()
                {
                    Address = introspectionAddress,
                    ClientId = clientId,
                    ClientSecret = clientSecret
                }
            );

            ITransactionApi transactionApi = Refit.RestService.For<ITransactionApi>(new HttpClient(new AuthenticationHandler(identityServerClient))
            {
                BaseAddress = new Uri(transactionApiAddress)
            });
            var TransactionStatus = transactionApi.Start(eServiceId).GetAwaiter().GetResult();

            this.client = new HttpClient(new AuthenticationHandler(identityServerClient))
            {
                BaseAddress = new Uri(baseAddress)
            };
            this.client.DefaultRequestHeaders.Add("x-transactionId", TransactionStatus.TransactionId);

        }

        public async Task Run()
        {
            await Multiply();
            await Divide();
        }

        private async Task Multiply()
        {
            JObject jsonObject = new JObject
            {
                { "Multiplier", 15 },
                { "Multiplicand", 20 }
            };

            var content = new StringContent(jsonObject.ToString(), Encoding.UTF8, "application/json");

            HttpResponseMessage response = await this.client.PostAsync("api/Calculator/Multiply", content);
            //HttpResponseMessage response = await this.client.GetAsync("legal-entity/90001733697");
            var status = ((int)response.StatusCode).ToString();
            if (status == "200")
            {
                string result = await response.Content.ReadAsStringAsync();
                Console.WriteLine(result);
            }
            else
            {
                throw new Exception($"Failed getting multiply : {response.ReasonPhrase}");
            }
        }

        private async Task Divide()
        {
            JObject jsonObject = new JObject
            {
                { "Dividend", 100 },
                { "Divisor", 5 }
            };

            var content = new StringContent(jsonObject.ToString(), Encoding.UTF8, "application/json");

            HttpResponseMessage response = await this.client.PostAsync("api/Calculator/Divide", content);
            var status = ((int)response.StatusCode).ToString();
            if (status == "200")
            {
                string result = await response.Content.ReadAsStringAsync();
                Console.WriteLine(result);
            }
            else
            {
                throw new Exception($"Failed getting divide : {response.ReasonPhrase}");
            }
        } 
    }
}
