﻿using IdentityModel.Client;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

namespace Viss.ApiManagement.Samples.Utils
{
    public class IdentityServerClient
    {
        private readonly HttpClient httpClient;
        private readonly PasswordTokenRequest passwordTokenRequest;
        private readonly ClientCredentialsTokenRequest clientCredentialstokenRequest;
        private readonly TokenIntrospectionRequest tokenIntrospectionRequest;

        public IdentityServerClient(PasswordTokenRequest passwordTokenRequest, ClientCredentialsTokenRequest clientCredentialstokenRequest, TokenIntrospectionRequest tokenIntrospectionRequest)
        {
            this.httpClient = new HttpClient();
            this.passwordTokenRequest = passwordTokenRequest;
            this.clientCredentialstokenRequest = clientCredentialstokenRequest;
            this.tokenIntrospectionRequest = tokenIntrospectionRequest;
        }

        public async Task<TokenResponse> GetAccessTokenPassword()
        {
            var tokenResponse = await httpClient.RequestPasswordTokenAsync(passwordTokenRequest);
            if (tokenResponse.IsError)
            {
                throw new Exception($"Failed getting system user token : {tokenResponse.ErrorDescription}");
            }

            return tokenResponse;
        }


        public async Task<TokenResponse> GetAccessTokenClientCredentials()
        {
            var tokenResponse = await httpClient.RequestClientCredentialsTokenAsync(clientCredentialstokenRequest);
            if (tokenResponse.IsError)
            {
                throw new Exception($"Failed getting system user token : {tokenResponse.ErrorDescription}");
            }

            return tokenResponse;
        } 

        public async Task<TokenIntrospectionResponse> GetIntrospection(string token)
        {
            tokenIntrospectionRequest.Token = token;
            var TokenIntrospectionResponse = await httpClient.IntrospectTokenAsync(tokenIntrospectionRequest);
            if (TokenIntrospectionResponse.IsError)
            {
                throw new Exception($"Failed getting token introspect : {TokenIntrospectionResponse.Error}");
            }
            return TokenIntrospectionResponse;
        }
    }
}
