﻿using IdentityModel.Client;
using Microsoft.Extensions.Caching.Memory;
using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Viss.ApiManagement.Samples.Utils
{
    public class AuthenticationHandler : DelegatingHandler
    {
        private const string BearerTokenKey = "BearerTokenKey";
        private readonly IdentityServerClient identityServerClient;
        private readonly IMemoryCache cache;

        public AuthenticationHandler(IdentityServerClient identityServerClient) : base(new HttpClientHandler())
        {
            this.identityServerClient = identityServerClient;
            this.cache = new MemoryCache(new MemoryCacheOptions());
        }

        protected override async Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken)
        {
            HttpResponseMessage response = null;
            async Task retry()
            {
                var tokenResponse = await identityServerClient.GetAccessTokenClientCredentials(); //or await identityServerClient.GetAccessTokenPassword()
                //var tokenResponse = await identityServerClient.GetAccessTokenPassword();

                /* Ir nokonfigurets lai tika izmantots sertifikats. Gadijuma ja ir nepieciesams veikt izsaukumus izmantojot username+pass, 
          * ir nepieciesams izveleties AuthenticationHandler.cs 31/32 rindu -> GetAccessTokenClientCredentials();) vai -> GetAccessTokenPassword();) 
          * un atkomentet rindu 30. 
          * Papildus SoapExample.cs vajag atkomentet 189 rindu, ieraksts (//TokenResponse tokenResponse = await identityServerClient.GetAccessTokenClientCredentials();) */

                if (tokenResponse != null && !string.IsNullOrEmpty(tokenResponse.AccessToken))
                {
                    var introspection = await identityServerClient.GetIntrospection(tokenResponse.AccessToken);

                    Console.WriteLine($"Introspection response for token {tokenResponse.AccessToken}");
                    Console.WriteLine(introspection.Raw);
                    Console.WriteLine();

                    cache.Set(BearerTokenKey, tokenResponse.AccessToken,
                        new MemoryCacheEntryOptions().SetAbsoluteExpiration(TimeSpan.FromSeconds(tokenResponse.ExpiresIn * 0.8)));
                    request.SetBearerToken(tokenResponse.AccessToken);
                }
                response = await base.SendAsync(request, cancellationToken);
            }

            if (cache.TryGetValue(BearerTokenKey, out string cachedToken) && !string.IsNullOrEmpty(cachedToken))
            {
                request.SetBearerToken(cachedToken);
                response = await base.SendAsync(request, cancellationToken);
            }
            else
            {
                await retry();
            }

            if (response.StatusCode == HttpStatusCode.Unauthorized
                || response.StatusCode == HttpStatusCode.Forbidden)
            {
                await retry();
            }

            return response;
        }

    }
}
