﻿using CalculationReference;
using IdentityModel.Client;
using Microsoft.IdentityModel.Tokens;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IdentityModel.Tokens;
using System.IdentityModel.Tokens.Jwt;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Security.Claims;
using System.Security.Cryptography.X509Certificates;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using Viss.ApiManagement.Samples.TransactionApi;
using Viss.ApiManagement.Samples.Utils;
using static CalculationReference.CalculationSyncClient;

namespace Viss.ApiManagement.Samples
{
    public class SoapExample
    {
        private readonly CalculationSyncClient client;
        private readonly IdentityServerClient identityServerClient;
        private readonly string transactionId;

        public SoapExample()
        {
            //string baseAddress = "https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithoutScope/v1_0/"; //testa vides SOAP servisa adrese bez scope
            string baseAddress = "https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope/v1_0/"; //testa vides SOAP servisa adrese ar scope
            string identityAddress = "https://apitestgw.vraa.gov.lv/token";; //VISS testa vide
            string introspectionAddress = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/introspect"; //VISS Testa vides introspect
            string jwtPayloadAudience = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/token"; //VISS testa vide
            string clientId = "f3737977-e9ee-437e-bc86-8710668ff4fb"; //Lietojuma Consumer_key no API Store.
            string clientSecret = "21d43ea06abb8d3c473285b8d20ac4435f12013n02a814faz437725ae38c32812"; //Lietojuma consumer_secret no API Store
            string userName = "username"; //PFAS AUTH lietotaja logins
            string password = "password"; //PFAS AUTH lietotāja parole
            string grantType = "password";
            ClientCredentialStyle clientCredentialStyle = ClientCredentialStyle.PostBody;
            string pathnameprivkeyfile = @"C:\\Users\\user\\Desktop\\certificate.pfx"; //sertifikāta fails
            string passwordprivkey = "certpassword"; //sertifikāta parole
            string scope = "ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope-v1_0-Calc"; //Ja SOAP servisi ir aizsargāti ar scope, tad šeit tiek uzskaitīti izsaucamo servisu scope/operācijas
            string transactionApiAddress = "https://vissapi-test.vraa.gov.lv/ApiManagement.TransactionApi";
            string eServiceId = "URN:IVIS:100001:EP-EP889-v1-0";

            //Scope-operacijas ir japievieno PFAS Uzticamo pušu saskarne - aplikacijam, ar kuram lietotajs ir parakstits uz servisu un veiks aizsargato API/servisu izsaukumus.
            var clientCertificate = new X509Certificate2(pathnameprivkeyfile, passwordprivkey);

            /* Lai datu nemeja autentifikacijam pieskirt Scope/atlaujas uz konkretiem servisiem - ir jabut Datu deveja atlaujam.
	        Piemera noraditie Scope/operacijas ir paredzeti SOAP servisam:
	        https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope/v1_0
	        Lai no mineta servisa sanemt rezultatu, ir nepieciesams
	        1)API Store ar TOKEN_CLIENT_ID noradito Klienta lietojumu pierakstities (subscribe) uz so servisu
	        2)PFAS Uzticamo pusu parvaldibas saskarne pievienot Scope/atlaujas lietotaja aplikacijai */

            var validFrom = DateTime.UtcNow;
            var validTo = validFrom + TimeSpan.FromSeconds(60000.0);
            var jwtHeader = new JwtHeader(new X509SigningCredentials(clientCertificate))
            {
                ["x5c"] = Convert.ToBase64String(clientCertificate.GetRawCertData())
            };
            var jwtPayload = new JwtPayload(
                issuer: clientId,
                audience: jwtPayloadAudience,
                claims: new List<Claim>() { new Claim("sub", clientId), new Claim("id", Guid.NewGuid().ToString()) },
                notBefore: validFrom,
                expires: validTo
                );
            var jwt = new JwtSecurityToken(jwtHeader, jwtPayload);
            var handler = new JwtSecurityTokenHandler();
            var assertion = handler.WriteToken(jwt);

            this.identityServerClient = new IdentityServerClient(
                new PasswordTokenRequest()
                {
                    Address = identityAddress,
                    ClientId = clientId,
                    ClientSecret = clientSecret,
                    UserName = userName,
                    Password = password,
                    GrantType = grantType,
                    Scope = scope,
                    ClientCredentialStyle = clientCredentialStyle
                },
                new ClientCredentialsTokenRequest()
                {
                    Address = identityAddress,
                    ClientId = clientId,
                    ClientSecret = clientSecret,
                    Scope = scope,
                    ClientAssertion = new ClientAssertion()
                    {
                        Type = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer",
                        Value = assertion,
                    }
                },
                new TokenIntrospectionRequest()
                {
                    Address = introspectionAddress,
                    ClientId = clientId,
                    ClientSecret = clientSecret
                }
            );

            ITransactionApi transactionApi = Refit.RestService.For<ITransactionApi>(new HttpClient(new AuthenticationHandler(identityServerClient))
            {
                BaseAddress = new Uri(transactionApiAddress)
            });
            var transactionStatus = transactionApi.Start(eServiceId).GetAwaiter().GetResult();
            transactionId = transactionStatus.TransactionId;
            this.client = new CalculationSyncClient(new BasicHttpBinding(BasicHttpSecurityMode.Transport), new EndpointAddress(baseAddress));
        }

        public async Task Run()
        {
            await Multiply();
            await Divide();
        }


        /* Ir nokonfigurets lai tika izmantots sertifikats. Gadijuma ja ir nepieciesams veikt izsaukumus izmantojot username+pass, 
         * ir nepieciesams izveleties AuthenticationHandler.cs 31/32 rindu -> GetAccessTokenClientCredentials();) vai -> GetAccessTokenPassword();) 
         * un atkomentet rindu 30. 
         * Papildus SoapExample.cs vajag atkomentet 189 rindu, ieraksts (//TokenResponse tokenResponse = await identityServerClient.GetAccessTokenClientCredentials();) */

        private async Task Multiply()
        {
            TokenResponse tokenResponse = await identityServerClient.GetAccessTokenClientCredentials();
            //TokenResponse tokenResponse = await identityServerClient.GetAccessTokenPassword();
            string accessToken = tokenResponse?.AccessToken;
            var introspection = await identityServerClient.GetIntrospection(accessToken);
            Console.WriteLine($"Introspection response for token {accessToken}");
            Console.WriteLine(introspection.Raw);
            Console.WriteLine();
            using (new OperationContextScope(client.InnerChannel))
            {
                OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = new HttpRequestMessageProperty()
                {
                    Headers =
                    {
                        { "Authorization", $"Bearer {accessToken}" },
                        { "x-transactionId", transactionId },
                    }
                };

                RequestHeaderStructure header = new RequestHeaderStructure()
                {
                    MessageID = "6cafe2c6-9834-47ad-b710-be8033710b02",
                    MessageType = "URN:IVIS:100001:XSD-Testing-TestISServise-v1-0-TYPE-Calculation",
                    TransactionID = transactionId,
                    CorrelationID = "f4ceae8a-dfd9-48b3-a0b6-5d990aaac86e",
                    Destination = "URN:IVIS:100001:ISS-SIA.ABC-CalculationDataSync-v1-0",
                    MilestoneID = "URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync",
                    Sender = new ParticipantStructure()
                    {
                        SystemID = "URN:IVIS:100001:PORTAL-Unknown",
                        Item = new InhabitantStructure()
                        {
                            PersonID = new PersonIDStructure()
                            {
                                Scheme = "urn:ivis:100001:name.id-viss",
                                Value = "PK:01020312345" //lietotaja personas kods
                            },
                            PersonCode = "01020312345", //lietotaja personas kods
                            FullName = new PersonFullNameStructure()
                            {
                                LastName = "Uzvards", //lietotaja Uzvards
                                FirstName = "Vards" //lietotaja Vards
                            }
                        }
                    }
                };

                IVISRequestStructure request = new IVISRequestStructure()
                {
                    Header = header,
                    Body = XElement.Parse(@"
                                    <Calculation xmlns=""http://ivis.eps.gov.lv/XMLSchemas/100000/TestISServise/v1-0"">
                                        <Number1>5</Number1>
	                                    <Number2>6</Number2>
	                                    <Operation>multiplication</Operation>
                                    </Calculation>")
                };

                DefaultMethodSyncResponse response = client.DefaultMethodSyncAsync(request).GetAwaiter().GetResult();
                Console.WriteLine(response.IVISResponse.Body.ToString());
            }
        }

        /* Ir nokonfigurets lai tika izmantots sertifikats. Gadijuma ja ir nepieciesams veikt izsaukumus izmantojot username+pass, 
          * ir nepieciesams izveleties AuthenticationHandler.cs 31/32 rindu -> GetAccessTokenClientCredentials();) vai -> GetAccessTokenPassword();) 
          * un atkomentet rindu 30. 
          * Papildus SoapExample.cs vajag atkomentet 189 rindu, ieraksts (//TokenResponse tokenResponse = await identityServerClient.GetAccessTokenClientCredentials();) */
        private async Task Divide()
        {
            TokenResponse tokenResponse = await identityServerClient.GetAccessTokenClientCredentials();
            //TokenResponse tokenResponse = await identityServerClient.GetAccessTokenPassword();
            string accessToken = tokenResponse?.AccessToken;
            var introspection = await identityServerClient.GetIntrospection(accessToken);
            Console.WriteLine($"\nIntrospection response for token {accessToken}");
            Console.WriteLine(introspection.Raw);
            Console.WriteLine();

            using (new OperationContextScope(client.InnerChannel))
            {
                OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = new HttpRequestMessageProperty()
                {
                    Headers =
                    {
                        { "Authorization", $"Bearer {accessToken}" },
                        { "x-transactionId", transactionId },
                    }
                };

                RequestHeaderStructure header = new RequestHeaderStructure()
                {
                    MessageID = "6cafe2c6-9834-47ad-b710-be8033710b02",
                    MessageType = "URN:IVIS:100001:XSD-Testing-TestISServise-v1-0-TYPE-Calculation",
                    TransactionID = transactionId,
                    CorrelationID = "f4ceae8a-dfd9-48b3-a0b6-5d990aaac86e",
                    Destination = "URN:IVIS:100001:ISS-SIA.ABC-CalculationDataSync-v1-0",
                    MilestoneID = "URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync",
                    Sender = new ParticipantStructure()
                    {
                        SystemID = "URN:IVIS:100001:PORTAL-Unknown",
                        Item = new InhabitantStructure()
                        {
                            PersonID = new PersonIDStructure()
                            {
                                Scheme = "urn:ivis:100001:name.id-viss",
                                Value = "PK:01020312345" //lietotaja personas kods
                            },
                            PersonCode = "01020312345", //lietotaja personas kods
                            FullName = new PersonFullNameStructure()
                            {
                                LastName = "Uzvards", //lietotaja Uzvards
                                FirstName = "Vards" //lietotaja Vards
                            }
                        }
                    }
                };


                IVISRequestStructure request = new IVISRequestStructure()
                {
                    Header = header,
                    Body = XElement.Parse(@"
                                    <Calculation xmlns=""http://ivis.eps.gov.lv/XMLSchemas/100000/TestISServise/v1-0"">
                                        <Number1>10</Number1>
	                                    <Number2>2</Number2>
	                                    <Operation>division</Operation>
                                    </Calculation>")
                };

                DefaultMethodSyncResponse response = client.DefaultMethodSyncAsync(request).GetAwaiter().GetResult();
                Console.WriteLine(response.IVISResponse.Body.ToString());
            }
        }
    }
}
