<?php
require_once("JWT.php");
use Firebase\JWT\JWT;

class Example{
	/*
	 *		SETTINGS START
	 */

	//getAccessToken() function settings - konfiguracija prieks izsaukumiem ar lietotajvardu un paroli
	const TOKEN_URL = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/token"; //VISS testa vides talona saite
	const TOKEN_CLIENT_ID = "16dac182-af92-4916-8fee-047b313039f5"; //Lietojuma Consumer_key no API Store.
	const TOKEN_CLIENT_SECRET = "954fa33e2ac7b5f3ca6a196f5cddd6395ed7199c3e448f4336973e032ac7931d"; //Lietojuma consumer_secret no API Store
	const TOKEN_USERNAME = "lietotajvards"; //PFAS AUTH lietotajvards
	const TOKEN_PASSWORD = "parole"; //PFAS AUTH parole
	//Ja API vai servisi ir aizsargati ar scope, tad seit tiek uzskaititi izsaucamo servisu scope/operacijas. Piemeram pievienotas visas scope prieks SOAP un REST
	const TOKEN_SCOPE = "API-RAPLM_VRAA-CalculationApiForTestsWithScope-v1_0-Multiply API-RAPLM_VRAA-CalculationApiForTestsWithScope-v1_0-Divide ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope-v1_0-Calc";
	//Scope-operacijas ir japievieno PFAS Uzticamo pusu saskarne - aplikacijam, ar kuram lietotajs ir parakstits uz servisu un veiks aizsargato API/servisu izsaukumus	

	//getAccessTokenWithSertificate() function settings - konfiguracija prieks izsaukumiem ar sertifikatu
	const CERTIFICATE_TOKEN_URL = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/token"; //VISS testa vides talona saite
	const CERTIFICATE = "sertifikata_nosaukums.pem"; //sertifikatam jabut viena mape ar index.php, formats *.pem (ja ir pfx, tad jaizmanto openssl lai parveidot pfx -> pem)
	const CERTIFICATE_PASSWORD = "sert_parole"; //sertifikata parole
	const CERTIFICATE_CLIENT_ID = "16dac182-af92-4916-8fee-047b313039f5"; //Lietojuma Consumer_key no API Store.
	const CERTIFICATE_CLIENT_SECRET = "954fa33e2ac7b5f3ca6a196f5cddd6395ed7199c3e448f4336973e032ac7931d"; //Lietojuma consumer_secret no API Store
	//Ja API vai servisi ir aizsargati ar scope, tad seit tiek uzskaititi izsaucamo servisu scope/operacijas. Piemeram pievienotas visas scope prieks SOAP un REST
	const CERTIFICATE_SCOPE = "API-RAPLM_VRAA-CalculationApiForTestsWithScope-v1_0-Multiply API-RAPLM_VRAA-CalculationApiForTestsWithScope-v1_0-Divide ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope-v1_0-Calc";
	//Scope-operacijas ir japievieno PFAS Uzticamo pusu saskarne - aplikacijam, ar kuram lietotajs ir parakstits uz servisu un veiks aizsargato API/servisu izsaukumus
	
	//multiply() and co function settings
	const SERVICE_BASE_ADDR = "https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithScope/v1_0/"; //testa vides REST servisa adrese ar scope
        //const SERVICE_BASE_ADDR = "https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithoutScope/v1_0/"; //testa vides REST servisa adrese bez scope
	const SOAP_SERVICE_BASE_ADDR = "https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope/v1_0/"; //testa vides SOAP servisa adrese ar scope
    //    const SOAP_SERVICE_BASE_ADDR = "https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithoutScope/v1_0/"; //testa vides SOAP servisa adrese ar scope


			/* Lai datu nemeja autentifikacijam pieskirt Scope/atlaujas uz konkretiem servisiem - ir jabut Datu deveja atlaujam.
            Piemera noraditie Scope/operacijas ir paredzeti API/servisam:
            https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithScope/v1_0/ 
			https://apitestgw.vraa.gov.lv/API-RAPLM_VRAA-CalculationApiForTestsWithoutScope/v1_0/
			https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithScope/v1_0/
			https://apitestgw.vraa.gov.lv/ISS-RAPLM_VRAA-SoapCalculationForTestsWithoutScope/v1_0/
            Lai no mineta servisa sanemt rezultatu, ir nepieciesams
            1)API Store ar TOKEN_CLIENT_ID noradito Klienta lietojumu pierakstities (subscribe) uz so servisu
            2)PFAS uzticamo pusu parvaldibas saskarne pievienot Scope/atlaujas lietotaja aplikacijai  */

	// Introspect() function settings
	const INTROSPECT_URL = "https://epakvisstv.vraa.gov.lv/STS/VISS.Pfas.STS/oauth2/introspect"; //VISS Testa introspect saite
	const API_ID = "16dac182-af92-4916-8fee-047b313039f5"; //Lietojuma Consumer_key no API Store.
	const API_SECRET = "954fa33e2ac7b5f3ca6a196f5cddd6395ed7199c3e448f4336973e032ac7931d"; //Lietojuma Consumer_secret no API Store.

	// transaction() function settings
	const TRANSACTION_URL = "https://vissapi-test.vraa.gov.lv/ApiManagement.TransactionApi/transactions"; //TransactionApi metode kas nepieciesama transakcijas uzsaksanai
	const ESERVICE_URN = "URN:IVIS:100001:EP-EP889-v1-0"; //Pakalpojuma transakcijas identifikators no kataloga

	// Sertificate - https://stackoverflow.com/questions/42006100/how-to-connect-to-api-using-php-with-a-pfx-file-and-password
	//               https://medium.com/better-programming/simple-example-using-json-web-tokens-with-php-and-jquery-c648a80854c
	// 		SETTINGS END

		// openssl pkcs12 -in c:\ABCTestCert.friendlyname.123-14.10.201919.34.43.pfx -out c:\Temp\ABCTestCert.friendlyname.123-14.10.201919.34.43.pem

	 

	 // Class variables
	 public $token;
	 public $transactionId;

	//zemak tiek definets ka bus sanemts token - ar sertifikatu vai ar lietotajvardu/paroli. nevajadzīgo vajag aizkomentet
	 function __construct(){
		 $this->token = $this->getAccessToken(); //ja autentifikacijai  izmantots lietotajvards un parole, gadijuma ja vajag veikt izsaukumu ar sertifikatu - so rindu ir jaaizkomente
		 //$this->token = $this->getAccessTokenWithSertificate(); //ja autentifikacijai tiek izmantots sertifikats, gadijuma ja vajag veikt izsaukumu ar lietotajvardu un paroli - so rindu ir jaaizkomente
		 $this->transactionId = $this->startTransaction();
	 }

	 function getAccessTokenWithSertificate(){

		$payload = [
			"sub" => self::CERTIFICATE_CLIENT_ID,
			"jti" => uniqid(),
			"iss" => self::CERTIFICATE_CLIENT_ID,
			"aud" => self::CERTIFICATE_TOKEN_URL,
			"nbf" => time(),
			"exp" => time() + 600
		];

		// Get public certificate
		$cert = openssl_x509_read(file_get_contents(self::CERTIFICATE));
		openssl_x509_export($cert, $str_cert);
		$pub_cert = str_replace([
			'-----BEGIN CERTIFICATE-----',
			'-----END CERTIFICATE-----',
			"\r\n",
			"\n",
		], [
			'',
			'',
			"\n",
			'',
		], $str_cert);

		//get thumbprint
		$fingerprint =  openssl_x509_fingerprint($cert,  $hash_algorithm = "sha1", $raw_output = true);
		
		$header = [
			"x5t" => JWT::urlsafeB64Encode($fingerprint),
			"x5c" => $pub_cert
		];

		$privateKey = openssl_pkey_get_private("file://" . __DIR__ . "\\" . self::CERTIFICATE, self::CERTIFICATE_PASSWORD);
		$jwt = JWT::encode($payload, $privateKey, "RS256", null, $header);
		openssl_free_key($privateKey);

		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, self::CERTIFICATE_TOKEN_URL);

		//Turn off all TLS security issues
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLINFO_HEADER_OUT, true);

		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring headers
		$headers = array(
			"cache-control: no-cache",
			"Accept: application/json"
		);

		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

		//Configuring post request
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, [
			"grant_type" => "client_credentials",
			"client_assertion_type" => "urn:ietf:params:oauth:client-assertion-type:jwt-bearer",
			"client_secret" => self::CERTIFICATE_CLIENT_SECRET,
			"client_id" => self::CERTIFICATE_CLIENT_ID,
			"client_assertion" => $jwt,
			"scope" => self::CERTIFICATE_SCOPE
		]);

		//Getting result
		$result = curl_exec($curl);
		$json = json_decode($result, true);
		curl_close($curl);

		return $json["access_token"];
	}

	// Gets access token
	public function getAccessToken(){

		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt ($curl, CURLOPT_URL, self::TOKEN_URL);

		//Turn off all TLS security issues
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLINFO_HEADER_OUT, true);

		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring post request
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, array(
			"grant_type" => "password",
			"username" => self::TOKEN_USERNAME,
			"password" => self::TOKEN_PASSWORD,
			"scope" => self::TOKEN_SCOPE,
			"client_id" => self::TOKEN_CLIENT_ID,
			"client_secret" => self::TOKEN_CLIENT_SECRET
		));

		//Getting result
		$result = curl_exec($curl);
		$json = json_decode($result, true);
		curl_close($curl);

		//return substr($json["access_token"], 9);
		return $json["access_token"];
	}

	public function multiply($multiplier, $multiplicant){

		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt ($curl, CURLOPT_URL, self::SERVICE_BASE_ADDR."api/Calculator/Multiply");
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);

		//Debug with Fiddler
		//curl_setopt($curl, CURLOPT_PROXY, '127.0.0.1:8888');

		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring post request & auth
		curl_setopt($curl, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json; charset=utf-8',
			'Authorization: Bearer ' . $this->token,
			'x-transactionId: ' . $this->transactionId
		));
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(array(
			'Multiplier' => $multiplier,
			'Multiplicand' => $multiplicant
		)));

		//Getting result
		$result = curl_exec($curl);
		$json = json_decode($result, true);
		curl_close($curl);

		return $result;
	}


	public function divide($divident, $divisor){
		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt ($curl, CURLOPT_URL, self::SERVICE_BASE_ADDR."api/Calculator/Divide");
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);

		//Debug with Fiddler
		//curl_setopt($curl, CURLOPT_PROXY, '127.0.0.1:8888');

		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring post request & auth
		curl_setopt($curl, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json; charset=utf-8',
			'Authorization: Bearer ' . $this->token,
			'x-transactionId: ' . $this->transactionId
		));
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(array(
			'Dividend' => $divident,
			'Divisor' => $divisor
		)));

		//Getting result
		$result = curl_exec($curl);
		$json = json_decode($result, true);
		curl_close($curl);

		return $result;
	}

	public function soapMultiply(){

		$envelope = <<< ENVELOPE_IND
		<s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/" xmlns:a="http://www.w3.org/2005/08/addressing" xmlns:u="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd">
			<s:Body xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
				<DefaultMethodSync xmlns="http://ivis.eps.gov.lv/ISS/IVISService/v1-0">
					<IVISRequest xmlns="http://ivis.eps.gov.lv/XMLSchemas/100001/IVIS/v1-0">
						<Header>
							<MessageID>73f30eaa-72e4-436d-a035-38652bc63c54</MessageID>
							<MessageType>URN:IVIS:100001:XSD-Testing-TestISServise-v1-0-TYPE-Calculation</MessageType>
							<TransactionID>URN:IVIS:100001:EP-EdkTester-v1-0-TR-1393</TransactionID>
							<CorrelationID>e6813a08-46b3-4249-90ec-aa60b4addb2c</CorrelationID>
							<Destination>URN:IVIS:100001:ISS-SIA.ABC-CalculationDataSync-v1-0</Destination>
						</Header>
						<Body>
							<Calculation xmlns="http://ivis.eps.gov.lv/XMLSchemas/100000/TestISServise/v1-0">
								<Number1>15</Number1>
								<Number2>20</Number2>
								<Operation>multiplication</Operation>
							</Calculation>
						</Body>
					</IVISRequest>
				</DefaultMethodSync>
			</s:Body>
		</s:Envelope>
ENVELOPE_IND;

		$soap_do = curl_init();

		// Fiddler proxy
		//curl_setopt($soap_do, CURLOPT_PROXY, '127.0.0.1:8888');

		curl_setopt($soap_do, CURLOPT_URL, self::SOAP_SERVICE_BASE_ADDR );
		curl_setopt($soap_do, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($soap_do, CURLOPT_TIMEOUT,        10);
		curl_setopt($soap_do, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt($soap_do, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($soap_do, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($soap_do, CURLOPT_POST,           true );
		curl_setopt($soap_do, CURLOPT_POSTFIELDS,     $envelope);
		curl_setopt($soap_do, CURLOPT_VERBOSE, TRUE);
		curl_setopt($soap_do, CURLOPT_HTTPHEADER, ['Authorization: Bearer '.$this->token, 'x-transactionId: '.$this->transactionId, "Content-Type: text/xml; charset=utf-8","SOAPAction: \"http://ivis.eps.gov.lv/ISS/IVISService/v1-0/DefaultMethodSync\"","Content-length: ".strlen($envelope)]);

		//Getting result & closing
		$result = curl_exec($soap_do);
		curl_close($soap_do);

		return ("Soap multiplication result: <br>".htmlentities($result)."<br>");
	}

	function getIntrospectResponse(){
		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt ($curl, CURLOPT_URL, self::INTROSPECT_URL);

		//Turn off all TLS security issues
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLINFO_HEADER_OUT, true);

		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring post request
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, [
			'token' => $this->token,
			'client_id' => self::API_ID,
			'client_secret' => self::API_SECRET
		]);

		//Getting result
		$result = curl_exec($curl);
		$json = json_decode($result, true);
		curl_close($curl);

		return $json;
	}

	// Start a transaction with a specific token
	function startTransaction(){
			// Initialize curl and set the API Endpoint url
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, self::TRANSACTION_URL);

			//Turn off all TLS security issues
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLINFO_HEADER_OUT, true);

			//Return result in string
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

			// set headers for the curl request
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json','Accept: application/json'));
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(array('eserviceId' => self::ESERVICE_URN)));

			//Getting result
			$result = curl_exec($curl);
			$json = json_decode($result, true);
			curl_close($curl);

			return $json["result"];
	}

}

$example = new Example();

echo "Access token: </br><strong>";
print_r($example->token);
echo "</strong></br></br>";

echo "Multiply result: </br><strong>";
echo $example->multiply(15, 15);
echo "</strong></br></br>";

echo "Divide result: </br><strong>";
echo $example->divide(150, 3);
echo "</strong></br></br>";

echo "Soap multiply result: </br><strong>";
echo $example->soapMultiply();
echo "</strong></br>";

echo "Introspect result: </br><strong>";
$introspect = $example->getIntrospectResponse();
print_r($introspect);
// echo "</br> Legal entity: ";
// print_r($introspect['legalentity']);
echo "</strong></br></br>";

echo "Transaction: </br><strong>";
print_r($example->transactionId);
echo "</strong></br></br>";
?>
